/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.configuration;

import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import com.cyberway.msf.commons.base.util.encrypt.EncryptUtils;
import com.cyberway.msf.commons.base.util.encrypt.StringEncryptor;
import com.cyberway.msf.commons.model.handler.EncryptTypeHandler;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CommonsBaseProperties.class})
public class EncryptorConfig {
    private final CommonsBaseProperties commonsBaseProperties;

    public EncryptorConfig(CommonsBaseProperties commonsBaseProperties) {
        this.commonsBaseProperties = commonsBaseProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={EncryptUtils.class})
    public EncryptUtils encryptUtils() {
        return new EncryptUtils();
    }

    @Bean
    public EncryptTypeHandler.EncryptorAdapter encryptorAdapter(final StringEncryptor stringEncryptor) {
        EncryptTypeHandler.EncryptorAdapter encryptorAdapter = new EncryptTypeHandler.EncryptorAdapter(){

            public String encrypt(String message) {
                return Boolean.TRUE.equals(EncryptorConfig.this.commonsBaseProperties.getEncryptor().getEncryptHandlerEnable()) ? stringEncryptor.encrypt(message) : message;
            }

            public String decrypt(String encryptedMessage) {
                if (Boolean.TRUE.equals(EncryptorConfig.this.commonsBaseProperties.getEncryptor().getEncryptHandlerEnable())) {
                    try {
                        return stringEncryptor.decrypt(encryptedMessage);
                    }
                    catch (Exception ex) {
                        return encryptedMessage;
                    }
                }
                return encryptedMessage;
            }
        };
        EncryptTypeHandler.setEncryptorAdapter((EncryptTypeHandler.EncryptorAdapter)encryptorAdapter);
        return encryptorAdapter;
    }
}

