/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.interceptor;

import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import java.sql.Connection;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class TableMappingInterceptor
implements Interceptor {
    private final CommonsBaseProperties commonsBaseProperties;

    public TableMappingInterceptor(CommonsBaseProperties commonsBaseProperties) {
        this.commonsBaseProperties = commonsBaseProperties;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        this.replaceSql(statementHandler.getBoundSql());
        return invocation.proceed();
    }

    private void replaceSql(BoundSql boundSql) throws IllegalAccessException {
        boolean replace = false;
        String replaceSql = boundSql.getSql();
        if (this.commonsBaseProperties != null && MapUtils.isNotEmpty(this.commonsBaseProperties.getSqlTableMapping())) {
            Map<String, String> tableMapping = this.commonsBaseProperties.getSqlTableMapping();
            for (Map.Entry<String, String> entry : tableMapping.entrySet()) {
                String key = StringUtils.wrap((String)entry.getKey(), (String)" ");
                if (!StringUtils.containsIgnoreCase((CharSequence)replaceSql, (CharSequence)key)) continue;
                replaceSql = StringUtils.replaceIgnoreCase((String)replaceSql, (String)key, (String)StringUtils.wrap((String)entry.getValue(), (String)" "));
                replace = true;
            }
        }
        if (replace) {
            FieldUtils.writeDeclaredField((Object)boundSql, (String)"sql", (Object)replaceSql, (boolean)true);
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

