/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.swagger;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.Operation;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2MapperImpl;

@Component
@Primary
public class ServiceModelToSwagger2MapperImplExt
extends ServiceModelToSwagger2MapperImpl {
    private static final String GET = "get";
    private static final String PUT = "put";
    private static final String POST = "post";
    private static final String HEAD = "head";
    private static final String DELETE = "delete";
    private static final String PATCH = "patch";
    private static final String OPTIONS = "options";
    private static final Logger logger = LoggerFactory.getLogger(ServiceModelToSwagger2MapperImplExt.class);

    public Swagger mapDocumentation(Documentation from) {
        Swagger swagger = super.mapDocumentation(from);
        swagger.setPaths(this.mapApiListings((Multimap<String, ApiListing>)from.getApiListings()));
        return swagger;
    }

    protected Map<String, Path> mapApiListings(Multimap<String, ApiListing> apiListings) {
        TreeMap paths = Maps.newTreeMap();
        for (ApiListing each : apiListings.values()) {
            for (ApiDescription api : each.getApis()) {
                paths.put(api.getPath(), this.mapOperations(api, (Optional<Path>)Optional.fromNullable(paths.get(api.getPath()))));
            }
        }
        return paths;
    }

    private Path mapOperations(ApiDescription api, Optional<Path> existingPath) {
        Path path = (Path)existingPath.or((Object)new Path());
        String method = null;
        io.swagger.models.Operation existOperation = null;
        for (Operation each : BuilderDefaults.nullToEmptyList((Collection)api.getOperations())) {
            method = each.getMethod().toString().toLowerCase();
            existOperation = this.get(method, path);
            if (existOperation != null && !StringUtils.startsWith((CharSequence)existOperation.getOperationId(), (CharSequence)"default_op")) continue;
            path.set(method, this.mapOperation(each));
        }
        return path;
    }

    private io.swagger.models.Operation get(String method, Path path) {
        if (GET.equals(method)) {
            return path.getGet();
        }
        if (PUT.equals(method)) {
            return path.getPut();
        }
        if (HEAD.equals(method)) {
            return path.getHead();
        }
        if (POST.equals(method)) {
            return path.getPost();
        }
        if (DELETE.equals(method)) {
            return path.getDelete();
        }
        if (PATCH.equals(method)) {
            return path.getPatch();
        }
        return OPTIONS.equals(method) ? path.getOptions() : null;
    }
}

