/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.swagger;

import com.cyberway.msf.commons.base.util.JsonUtils;
import com.cyberway.msf.commons.cache.RedisUtils;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.env.Environment;
import springfox.documentation.service.Documentation;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;

public class SwaggerApiCacheImpl
implements CommandLineRunner {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DocumentationCache documentationCache;
    private final ServiceModelToSwagger2Mapper mapper;
    private final RedisUtils redisUtils;
    private final Environment environment;

    public SwaggerApiCacheImpl(DocumentationCache documentationCache, ServiceModelToSwagger2Mapper mapper, RedisUtils redisUtils, Environment environment) {
        this.documentationCache = documentationCache;
        this.mapper = mapper;
        this.redisUtils = redisUtils;
        this.environment = environment;
    }

    public void run(String ... args) throws Exception {
        String groupName = "default";
        Documentation documentation = this.documentationCache.documentationByGroup(groupName);
        if (documentation == null) {
            return;
        }
        Swagger swagger = this.mapper.mapDocumentation(documentation);
        if (swagger.getPaths().isEmpty()) {
            return;
        }
        TreeMap<String, Map<String, Object>> apis = new TreeMap<String, Map<String, Object>>();
        for (Map.Entry entry : swagger.getPaths().entrySet()) {
            String url = (String)entry.getKey();
            Path path = (Path)entry.getValue();
            this.addApis(apis, url, "get", path.getGet());
            this.addApis(apis, url, "put", path.getPut());
            this.addApis(apis, url, "head", path.getHead());
            this.addApis(apis, url, "post", path.getPost());
            this.addApis(apis, url, "delete", path.getDelete());
            this.addApis(apis, url, "path", path.getPatch());
            this.addApis(apis, url, "options", path.getOptions());
        }
        String appName = this.environment.getProperty("spring.application.name");
        String key = String.format("swaggerApi:%s", appName);
        this.redisUtils.setOrigin(key, (Object)JsonUtils.toJson(apis));
        this.logger.info("cache swagger api.");
    }

    private void addApis(Map<String, Map<String, Object>> apis, String url, String method, Operation op) {
        if (op != null) {
            String tag = CollectionUtils.isNotEmpty((Collection)op.getTags()) ? (String)op.getTags().get(0) : "";
            String name = StringUtils.defaultString((String)op.getSummary());
            HashMap<String, String> apiInfo = new HashMap<String, String>();
            apiInfo.put("tag", tag);
            apiInfo.put("name", name);
            apiInfo.put("path", url);
            apis.put(method + ":" + url, apiInfo);
        }
    }
}

