/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.xss;

import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.safety.Cleaner;
import org.jsoup.safety.Whitelist;
import org.springframework.web.util.HtmlUtils;

public class XssUtil {
    private static final HtmlWhitelist WHITE_LIST = new HtmlWhitelist();
    private static final Document.OutputSettings OUTPUT_SETTINGS = new Document.OutputSettings().escapeMode(Entities.EscapeMode.xhtml).prettyPrint(false);

    public static String clean(String html, Boolean autoEscape) {
        if (StringUtils.isBlank((CharSequence)html)) {
            return html;
        }
        Document dirty = Jsoup.parseBodyFragment((String)html, (String)"");
        Cleaner cleaner = new Cleaner((Whitelist)WHITE_LIST);
        Document clean = cleaner.clean(dirty);
        clean.outputSettings(OUTPUT_SETTINGS);
        String retHtml = clean.body().html();
        Element body = clean.body();
        if (body.childNodeSize() == 0 || body.textNodes().size() == body.childNodeSize()) {
            retHtml = Entities.unescape((String)retHtml);
            if (Boolean.TRUE.equals(autoEscape) && !XssUtil.isUrl(retHtml)) {
                retHtml = HtmlUtils.htmlEscape((String)retHtml);
                retHtml = StringUtils.replace((String)retHtml, (String)"&middot;", (String)"\u00b7");
            }
        }
        return retHtml;
    }

    private static boolean isUrl(String str) {
        return StringUtils.startsWithAny((CharSequence)StringUtils.trimToEmpty((String)str), (CharSequence[])new CharSequence[]{"http://", "https://"});
    }

    public static class HtmlWhitelist
    extends Whitelist {
        public HtmlWhitelist() {
            this.addTags(new String[]{"a", "b", "blockquote", "br", "caption", "cite", "code", "col", "colgroup", "dd", "div", "span", "embed", "object", "dl", "dt", "em", "h1", "h2", "h3", "h4", "h5", "h6", "i", "img", "li", "ol", "p", "pre", "q", "small", "strike", "strong", "sub", "sup", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "u", "ul"});
            this.addAttributes("a", new String[]{"href", "title", "target"});
            this.addAttributes("blockquote", new String[]{"cite"});
            this.addAttributes("col", new String[]{"span"});
            this.addAttributes("colgroup", new String[]{"span"});
            this.addAttributes("img", new String[]{"align", "alt", "src", "title"});
            this.addAttributes("ol", new String[]{"start"});
            this.addAttributes("q", new String[]{"cite"});
            this.addAttributes("table", new String[]{"summary", "align"});
            this.addAttributes("td", new String[]{"abbr", "axis", "colspan", "rowspan", "width", "valign", "align"});
            this.addAttributes("th", new String[]{"abbr", "axis", "colspan", "rowspan", "scope", "width", "valign", "align"});
            this.addAttributes("video", new String[]{"src", "autoplay", "controls", "loop", "muted", "poster", "preload"});
            this.addAttributes("object", new String[]{"width", "height", "classid", "codebase"});
            this.addAttributes("param", new String[]{"name", "value"});
            this.addAttributes("embed", new String[]{"src", "quality", "width", "height", "allowFullScreen", "allowScriptAccess", "flashvars", "name", "type", "pluginspage"});
            this.addAttributes(":all", new String[]{"class", "style", "height", "width", "type", "id", "name"});
            this.addProtocols("blockquote", "cite", new String[]{"http", "https"});
            this.addProtocols("cite", "cite", new String[]{"http", "https"});
            this.addProtocols("q", "cite", new String[]{"http", "https"});
        }

        protected boolean isSafeAttribute(String tagName, Element el, Attribute attr) {
            String value;
            if (("src".equalsIgnoreCase(attr.getKey()) || "href".equalsIgnoreCase(attr.getKey())) && StringUtils.isNotBlank((CharSequence)(value = attr.getValue())) && value.toLowerCase().startsWith("javascript")) {
                return false;
            }
            if ("img".equals(tagName) && "src".equals(attr.getKey()) && attr.getValue().startsWith("data:;base64")) {
                return true;
            }
            return super.isSafeAttribute(tagName, el, attr);
        }
    }
}

