/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import java.util.Objects;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    public static String desensitizeLeft(String str, int left) {
        return StringUtils.desensitize(str, left, 0);
    }

    public static String desensitizeRight(String str, int right) {
        return StringUtils.desensitize(str, 0, right);
    }

    public static String desensitize(String str, int left, int right) {
        int len;
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        int sum = Math.max(left, 0) + Math.max(right, 0);
        if (sum < (len = str.length())) {
            StringBuilder buf = new StringBuilder(len);
            if (left > 0) {
                buf.append(StringUtils.left((String)str, (int)left));
            }
            buf.append(StringUtils.repeat((String)"*", (int)(len - sum)));
            if (right > 0) {
                buf.append(StringUtils.right((String)str, (int)right));
            }
            return buf.toString();
        }
        return str;
    }

    public static String desensitizeMobile(String str) {
        return StringUtils.desensitize(str, 3, 4);
    }

    public static String desensitizeCertNo(String str) {
        if (StringUtils.length((CharSequence)str) <= 9) {
            return StringUtils.desensitize(str, 2, 3);
        }
        return StringUtils.desensitize(str, 3, 4);
    }

    public static String desensitizeName(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        return StringUtils.substring((String)StringUtils.trimToEmpty((String)str), (int)0, (int)1) + "**";
    }

    public static String longToStr(Long id) {
        return Objects.isNull(id) ? null : String.valueOf(id);
    }

    public static Long strToLong(String id) {
        return StringUtils.isBlank((CharSequence)id) ? null : Long.valueOf(id);
    }
}

