/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import com.cyberway.msf.commons.base.util.JsonUtils;
import com.cyberway.msf.commons.base.util.StringUtils;
import com.cyberway.msf.commons.cache.RedisUtils;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.org.vo.employee.EmployeeVo;
import com.cyberway.msf.org.vo.organization.OrganizationCacheVO;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class UserUtils {
    private static final String REQUEST_LOGGED_IN_USER = "loggedInUser";
    private static final ThreadLocal<UserInfo> CURRENT_USER_HOLDER = new ThreadLocal();
    private static final ThreadLocal<UserInfo> INHERITABLE_CURRENT_USER_HOLDER = new InheritableThreadLocal<UserInfo>();
    @Autowired
    private RedisUtils redisUtils;
    @Autowired(required=false)
    private CommonsBaseProperties commonsBaseProperties;
    private static UserUtils userUtils;

    @PostConstruct
    public void init() {
        userUtils = this;
    }

    private static UserInfo getLocalUserInfo() {
        UserInfo userInfo = CURRENT_USER_HOLDER.get();
        if (null == userInfo) {
            userInfo = INHERITABLE_CURRENT_USER_HOLDER.get();
        }
        return userInfo;
    }

    public static void setLocalUserInfo(UserInfo userInfo, boolean inheritable) {
        if (userInfo == null) {
            UserUtils.resetLocalUserInfo();
        } else if (inheritable) {
            INHERITABLE_CURRENT_USER_HOLDER.set(userInfo);
            CURRENT_USER_HOLDER.remove();
        } else {
            CURRENT_USER_HOLDER.set(userInfo);
            INHERITABLE_CURRENT_USER_HOLDER.remove();
        }
    }

    public static void resetLocalUserInfo() {
        CURRENT_USER_HOLDER.remove();
        INHERITABLE_CURRENT_USER_HOLDER.remove();
    }

    public static String getCurrentToken() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            return request.getHeader("Authorization");
        }
        return null;
    }

    private static UserInfo getUserInfoByRequest() {
        UserInfo userInfo = null;
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            userInfo = (UserInfo)attributes.getAttribute(REQUEST_LOGGED_IN_USER, 0);
        }
        return userInfo;
    }

    private static UserInfo setUserInfoByRequest(UserInfo userInfo) {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            attributes.setAttribute(REQUEST_LOGGED_IN_USER, (Object)userInfo, 0);
        }
        return userInfo;
    }

    public static UserInfo getLoggedInUser() {
        UserInfo userInfo = UserUtils.getUserInfoByRequest();
        if (userInfo == null) {
            String token = UserUtils.getCurrentToken();
            userInfo = token == null ? UserUtils.getLocalUserInfo() : UserUtils.getUserInfoByToken(token);
            userInfo = UserUtils.setUserInfoByRequest(userInfo);
        }
        return userInfo;
    }

    public static UserInfo getUserInfoByToken(String token) {
        if (token == null) {
            return null;
        }
        String key = String.format("loginInfo:%s", token);
        String userJson = (String)UserUtils.userUtils.redisUtils.getHashOrigin(key, (Object)"userInfo");
        return null == userJson ? null : (UserInfo)JSON.parseObject((String)userJson, UserInfo.class);
    }

    public static Long getOrgId() {
        UserInfo userInfo = UserUtils.getLoggedInUser();
        return userInfo == null ? null : userInfo.getOrgId();
    }

    public static Long getTenantId() {
        UserInfo userInfo = UserUtils.getLoggedInUser();
        return userInfo == null ? null : userInfo.getTenantId();
    }

    public static EmployeeVo getEmployee() {
        String token = UserUtils.getCurrentToken();
        if (token == null) {
            return null;
        }
        String key = String.format("loginInfo:%s", token);
        String employeeJson = (String)UserUtils.userUtils.redisUtils.getHashOrigin(key, (Object)"employee");
        return null == employeeJson ? null : (EmployeeVo)JSON.parseObject((String)employeeJson, EmployeeVo.class);
    }

    public static Long getDutyId() {
        return UserUtils.getLongLoginInfoValue("dutyId");
    }

    public static Long getCompanyId() {
        return UserUtils.getLongLoginInfoValue("companyId");
    }

    public static Long getDepartmentId() {
        return UserUtils.getLongLoginInfoValue("departmentId");
    }

    public static boolean hasRoleCategory(String roleCategoryCode) {
        String token = UserUtils.getCurrentToken();
        if (token == null) {
            return false;
        }
        String key = String.format("loginInfo:%s", token);
        String rolesJson = (String)UserUtils.userUtils.redisUtils.getHashOrigin(key, (Object)"roles");
        if (StringUtils.isNotBlank((CharSequence)rolesJson)) {
            return JSON.parseArray((String)rolesJson).stream().filter(role -> role instanceof JSONObject && StringUtils.equals((CharSequence)((JSONObject)role).getString("roleCategoryCode"), (CharSequence)roleCategoryCode)).findFirst().isPresent();
        }
        return false;
    }

    private static Long getLongLoginInfoValue(String mapKey) {
        String token = UserUtils.getCurrentToken();
        if (token == null) {
            return null;
        }
        String key = String.format("loginInfo:%s", token);
        Object value = UserUtils.userUtils.redisUtils.getHashOrigin(key, (Object)mapKey);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        return null;
    }

    public static boolean isAdministrator() {
        return UserUtils.hasRoleType("Administrator");
    }

    public static boolean isSuperAdministrator() {
        return UserUtils.hasRoleType("SuperAdministrator");
    }

    public static boolean isSystemAdministrator() {
        return UserUtils.hasRoleType("SystemAdministrator");
    }

    public static boolean hasRoleType(String roleType) {
        String token = UserUtils.getCurrentToken();
        if (token == null) {
            return false;
        }
        String key = String.format("loginInfo:%s", token);
        List roleTypes = (List)UserUtils.userUtils.redisUtils.getHashOrigin(key, (Object)"roleTypes");
        return CollectionUtils.isNotEmpty((Collection)roleTypes) && roleTypes.contains(roleType);
    }

    public static boolean isSuperTenantAdmin() {
        UserInfo userInfo = UserUtils.getLoggedInUser();
        return null != userInfo && "0000".equals(userInfo.getTenantCode()) && UserUtils.isAdministrator();
    }

    public static Boolean isSingleTenant() {
        return UserUtils.userUtils.commonsBaseProperties != null && Boolean.TRUE.equals(UserUtils.userUtils.commonsBaseProperties.getSingleTenant());
    }

    public static UserInfo setLocalAnonymousUser(Long tenantId, Long orgId, String tenantCode, boolean inheritable) {
        UserInfo userInfo = UserUtils.getAnonymousUser(tenantId, orgId, tenantCode);
        UserUtils.setLocalUserInfo(userInfo, inheritable);
        return userInfo;
    }

    public static UserInfo getAnonymousUser(Long tenantId, Long orgId) {
        return UserUtils.getAnonymousUser(tenantId, orgId, "");
    }

    public static UserInfo getAnonymousUser(Long tenantId, Long orgId, String tenantCode) {
        UserInfo userInfo;
        String token = tenantId + "_" + orgId;
        String key = String.format("loginInfo:%s", token);
        String userJson = (String)UserUtils.userUtils.redisUtils.getHashOrigin(key, (Object)"userInfo");
        if (null == userJson) {
            userInfo = UserUtils.cacheAnonymousUser(tenantId, orgId, tenantCode);
        } else {
            userInfo = (UserInfo)JSON.parseObject((String)userJson, UserInfo.class);
            userInfo.setToken(token);
        }
        return userInfo;
    }

    public static UserInfo cacheAnonymousUser(Long tenantId, Long orgId, String tenantCode) {
        String token = tenantId + "_" + orgId;
        String key = String.format("loginInfo:%s", token);
        UserInfo userInfo = new UserInfo();
        userInfo.setTenantId(tenantId);
        userInfo.setOrgId(orgId);
        userInfo.setTenantCode(tenantCode);
        userInfo.setToken(token);
        userInfo.setFullName("system");
        UserUtils.userUtils.redisUtils.putHashOrigin(key, (Object)"userInfo", (Object)JSON.toJSONString((Object)userInfo));
        return userInfo;
    }

    public static List<OrganizationCacheVO> getAllOrgList() {
        String jsonStr = (String)UserUtils.userUtils.redisUtils.getOrigin("org:all");
        List<OrganizationCacheVO> orgList = null;
        if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
            orgList = JsonUtils.parseList(jsonStr, OrganizationCacheVO.class);
        }
        return Optional.ofNullable(orgList).orElse(Collections.emptyList());
    }

    public static OrganizationCacheVO getDefaultOrganization() {
        String defaultCode = UserUtils.userUtils.commonsBaseProperties != null ? UserUtils.userUtils.commonsBaseProperties.getDefaultTenantCode() : "";
        return UserUtils.getAllOrgList().stream().filter(org -> StringUtils.equals((CharSequence)defaultCode, (CharSequence)org.getCodeName())).findFirst().orElse(null);
    }
}

