/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util.encrypt;

import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import com.cyberway.msf.commons.base.util.encrypt.StringEncryptor;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.util.Base64Utils;

@Service(value="stringEncryptor")
@ConditionalOnProperty(prefix="commons.base.encryptor", name={"type"}, havingValue="AES", matchIfMissing=true)
public class AesStringEncryptor
implements StringEncryptor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CommonsBaseProperties commonsBaseProperties;

    public AesStringEncryptor(CommonsBaseProperties commonsBaseProperties) {
        this.commonsBaseProperties = commonsBaseProperties;
    }

    @Override
    public String encrypt(String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return data;
        }
        byte[] byteContent = data.getBytes(StandardCharsets.UTF_8);
        try {
            byte[] password = this.commonsBaseProperties.getEncryptor().getPassword().getBytes(StandardCharsets.UTF_8);
            SecretKeySpec key = new SecretKeySpec(password, "AES");
            IvParameterSpec iv = new IvParameterSpec(password);
            Cipher encryptCipher = Cipher.getInstance(this.commonsBaseProperties.getEncryptor().getAlgorithm());
            encryptCipher.init(1, (Key)key, iv);
            byte[] resultBytes = encryptCipher.doFinal(byteContent);
            return Base64Utils.encodeToString((byte[])resultBytes);
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u52a0\u5bc6\u6570\u636e\u5931\u8d25", e);
        }
    }

    @Override
    public String decrypt(String encryptedData) {
        if (StringUtils.isBlank((CharSequence)encryptedData)) {
            return encryptedData;
        }
        try {
            byte[] byteContent = Base64Utils.decodeFromString((String)encryptedData);
            byte[] password = this.commonsBaseProperties.getEncryptor().getPassword().getBytes(StandardCharsets.UTF_8);
            SecretKeySpec key = new SecretKeySpec(password, "AES");
            IvParameterSpec iv = new IvParameterSpec(password);
            Cipher decryptCipher = Cipher.getInstance(this.commonsBaseProperties.getEncryptor().getAlgorithm());
            decryptCipher.init(2, (Key)key, iv);
            byte[] resultBytes = decryptCipher.doFinal(byteContent);
            return new String(resultBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u89e3\u5bc6\u6570\u636e\u5931\u8d25", e);
        }
    }
}

