/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util.id;

import com.cyberway.msf.commons.base.support.configuration.SnowflakeProperties;
import com.cyberway.msf.commons.base.util.id.IdGenerator;
import com.cyberway.msf.commons.cache.RedisUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeIdGenerator
implements IdGenerator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String REDIS_WORKER_ID_LIST_PREFIX = "workerId:";
    private static final String REDIS_USING_WORKER_ID_PREFIX = "usingWorkerId:";
    private static final String REDIS_LAST_WORKER_ID_BEAT_PREFIX = "lastWorkerIdBeat:";
    private static final String REDIS_LAST_WORKER_ID_NO_BEAT_PREFIX = "maxWorkerIdNoBeat:";
    private volatile Long workerId;
    private final AtomicInteger heartBeatFailCount = new AtomicInteger(0);
    private final int maxHeartBeatFailTimes;
    private final long maxWorkerId;
    private final long workerIdShift;
    private final long dataCenterIdShift;
    private final long timestampShift;
    private final long sequenceMask;
    private final SnowflakeProperties snowflakeProperties;
    private final RedisUtils redisUtils;
    private final Map<String, Long> sequenceMap = new HashMap<String, Long>();
    private final ScheduledExecutorService executorService;
    private long lastTimestamp = -1L;
    private long sequence = 0L;

    public SnowflakeIdGenerator(SnowflakeProperties snowflakeProperties, RedisUtils redisUtils) {
        long sequenceBits;
        this.snowflakeProperties = snowflakeProperties == null ? new SnowflakeProperties() : snowflakeProperties;
        this.redisUtils = redisUtils;
        long maxDataCenterId = -1L << (int)this.snowflakeProperties.getDataCenterIdBits() ^ 0xFFFFFFFFFFFFFFFFL;
        if (this.snowflakeProperties.getDataCenterId() > maxDataCenterId) {
            throw new BaseException("dataCenterId[" + this.snowflakeProperties.getDataCenterId() + "] bigger than maxDataCenterId[" + maxDataCenterId + "]");
        }
        this.maxWorkerId = -1L << (int)this.snowflakeProperties.getWorkerIdBits() ^ 0xFFFFFFFFFFFFFFFFL;
        this.workerIdShift = sequenceBits = 22L - this.snowflakeProperties.getDataCenterIdBits() - this.snowflakeProperties.getWorkerIdBits();
        this.dataCenterIdShift = sequenceBits + this.snowflakeProperties.getWorkerIdBits();
        this.timestampShift = sequenceBits + this.snowflakeProperties.getWorkerIdBits() + this.snowflakeProperties.getDataCenterIdBits();
        this.sequenceMask = -1L << (int)sequenceBits ^ 0xFFFFFFFFFFFFFFFFL;
        if (this.snowflakeProperties.getWorkerId() != null) {
            this.workerId = this.snowflakeProperties.getWorkerId();
            if (this.workerId > this.maxWorkerId) {
                throw new BaseException("new workerId[" + this.workerId + "] bigger than maxWorkerId[" + this.maxWorkerId + "]");
            }
        } else if (this.snowflakeProperties.isRedisWorkerId() && redisUtils != null) {
            this.newRedisWorkerId();
        } else {
            this.workerId = this.macWorkerId();
        }
        if (this.snowflakeProperties.getRedisHeartBeatMinutes() > 0 && this.snowflakeProperties.isRedisWorkerId() && redisUtils != null) {
            this.maxHeartBeatFailTimes = this.snowflakeProperties.getRedisWorkerIdExpireMinutes() / this.snowflakeProperties.getRedisHeartBeatMinutes();
            this.executorService = new ScheduledThreadPoolExecutor(2, r -> {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                thread.setName(SnowflakeIdGenerator.class.getName() + "_redisHeatBeat");
                return thread;
            });
            this.executorService.schedule(new BeatTask(), (long)this.snowflakeProperties.getRedisHeartBeatMinutes(), TimeUnit.MINUTES);
        } else {
            this.maxHeartBeatFailTimes = 0;
            this.executorService = null;
        }
    }

    @Override
    public synchronized Long generateId(Object entity) {
        if (this.workerId == null) {
            this.newRedisWorkerId();
        }
        Class<?> clazz = entity instanceof Class ? (Class<?>)entity : entity.getClass();
        long currentTimestamp = System.currentTimeMillis();
        if (this.checkTimeBackward(currentTimestamp)) {
            return this.generateId(entity);
        }
        if (this.snowflakeProperties.isSplitSequenceByClass()) {
            this.sequence = this.sequenceMap.getOrDefault(clazz.getCanonicalName(), 0L);
        }
        if (this.lastTimestamp == currentTimestamp) {
            this.sequence = this.sequence + 1L & this.sequenceMask;
            if (this.sequence == 0L) {
                currentTimestamp = this.waitUntilNextTime(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
            if (this.snowflakeProperties.isSplitSequenceByClass()) {
                this.sequenceMap.clear();
            }
        }
        this.lastTimestamp = currentTimestamp;
        long timestamp = currentTimestamp - this.snowflakeProperties.getEpoch() << (int)this.timestampShift;
        long workerIdPart = this.workerId << (int)this.workerIdShift;
        long dataCenterIdPart = this.snowflakeProperties.getDataCenterId() << (int)this.dataCenterIdShift;
        if (this.snowflakeProperties.isSplitSequenceByClass()) {
            this.sequenceMap.put(clazz.getCanonicalName(), this.sequence);
        }
        return timestamp | dataCenterIdPart | workerIdPart | this.sequence;
    }

    private boolean checkTimeBackward(long currentTimestamp) {
        if (currentTimestamp < this.lastTimestamp) {
            long offset = this.lastTimestamp - currentTimestamp;
            if (offset <= this.snowflakeProperties.getMaxBackwardMs()) {
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(offset));
                return true;
            }
            if (this.snowflakeProperties.isRedisWorkerId() && this.redisUtils != null) {
                this.newRedisWorkerId();
                this.lastTimestamp = currentTimestamp;
                this.sequence = 0L;
                if (this.snowflakeProperties.isSplitSequenceByClass()) {
                    this.sequenceMap.clear();
                }
            } else {
                throw new BaseException("currentTimestamp[" + currentTimestamp + "] less than lastTimestamp[" + this.lastTimestamp + "]");
            }
        }
        return false;
    }

    private long waitUntilNextTime(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }

    public Long getWorkerId() {
        return this.workerId;
    }

    public void destroy() {
        this.logger.info("SnowflakeIdGenerator destroy");
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.snowflakeProperties.isRedisWorkerId() && this.redisUtils != null) {
            this.returnOldWorkerId(this.workerId);
        }
    }

    private synchronized void newRedisWorkerId() {
        String key = this.snowflakeProperties.getRedisWorkerIdPrefix() + REDIS_WORKER_ID_LIST_PREFIX + this.snowflakeProperties.getDataCenterId();
        Long oldWorkerId = null;
        if (this.workerId != null) {
            oldWorkerId = this.workerId;
            this.workerId = null;
        }
        this.workerId = (Long)this.redisUtils.listLeftPop(key);
        if (this.workerId == null) {
            Long newId = null;
            try {
                newId = this.createNewRedisWorkerId();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            if (newId == null) {
                this.workerId = oldWorkerId;
                throw new BaseException("create new redis workerId failed");
            }
            this.workerId = newId;
        }
        this.returnOldWorkerId(oldWorkerId);
        this.logger.info("Get new redis workerId[{}]", (Object)this.workerId);
    }

    private Long createNewRedisWorkerId() {
        if (this.snowflakeProperties.getRedisHeartBeatMinutes() > 0) {
            String lastWorkerIdKey = this.snowflakeProperties.getRedisWorkerIdPrefix() + REDIS_LAST_WORKER_ID_BEAT_PREFIX + this.snowflakeProperties.getDataCenterId();
            Object lastWorkerId = this.redisUtils.get(lastWorkerIdKey);
            long lastId = lastWorkerId instanceof Integer ? ((Integer)lastWorkerId).longValue() : (lastWorkerId instanceof Long ? (Long)lastWorkerId : this.maxWorkerId);
            for (long newId = lastId + 1L; newId != lastId; ++newId) {
                Boolean result;
                if (newId > this.maxWorkerId) {
                    newId = 0L;
                }
                if (!Boolean.TRUE.equals(result = this.redisUtils.setIfAbsent(this.buildUsingWorkerIdKey(newId), (Object)1, (long)this.snowflakeProperties.getRedisWorkerIdExpireMinutes() * 60L))) continue;
                this.redisUtils.set(lastWorkerIdKey, (Object)newId);
                this.heartBeatFailCount.set(0);
                return newId;
            }
            this.logger.warn("Not enough workerId");
            return null;
        }
        String lastWorkerIdKey = this.snowflakeProperties.getRedisWorkerIdPrefix() + REDIS_LAST_WORKER_ID_NO_BEAT_PREFIX + this.snowflakeProperties.getDataCenterId();
        long maxId = this.redisUtils.generate(lastWorkerIdKey);
        if (maxId - 1L > this.maxWorkerId) {
            this.logger.warn("Not enough workerId");
            return null;
        }
        return maxId - 1L;
    }

    private String buildUsingWorkerIdKey(Long usingWorkerId) {
        return this.snowflakeProperties.getRedisWorkerIdPrefix() + REDIS_USING_WORKER_ID_PREFIX + this.snowflakeProperties.getDataCenterId() + ":" + usingWorkerId;
    }

    private void returnOldWorkerId(Long oldWorkerId) {
        if (oldWorkerId != null) {
            try {
                this.redisUtils.listRightPush(this.snowflakeProperties.getRedisWorkerIdPrefix() + REDIS_WORKER_ID_LIST_PREFIX + this.snowflakeProperties.getDataCenterId(), (Object)oldWorkerId);
                if (this.snowflakeProperties.getRedisHeartBeatMinutes() > 0) {
                    this.redisUtils.del(new String[]{this.buildUsingWorkerIdKey(oldWorkerId)});
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private long macWorkerId() {
        long id;
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network == null) {
                id = 1L;
            } else {
                byte[] mac = network.getHardwareAddress();
                id = (0xFFL & (long)mac[mac.length - 1] | 0xFF00L & (long)mac[mac.length - 2] << 8) >> 6;
                id %= this.maxWorkerId + 1L;
            }
            String name = ManagementFactory.getRuntimeMXBean().getName();
            if (StringUtils.isNotBlank((CharSequence)name)) {
                id = (long)((id + name.split("@")[0]).hashCode() & 0xFFFF) % (this.maxWorkerId + 1L);
            }
        }
        catch (Exception e) {
            throw new BaseException("create workerId by mac failed:" + e.getMessage(), (Throwable)e);
        }
        this.logger.info("Get new mac workerId[{}]", (Object)id);
        return id;
    }

    class BeatTask
    implements Runnable {
        BeatTask() {
        }

        @Override
        public void run() {
            block8: {
                if (SnowflakeIdGenerator.this.workerId != null) {
                    try {
                        Boolean expire = SnowflakeIdGenerator.this.redisUtils.expire(SnowflakeIdGenerator.this.buildUsingWorkerIdKey(SnowflakeIdGenerator.this.workerId), (long)SnowflakeIdGenerator.this.snowflakeProperties.getRedisWorkerIdExpireMinutes() * 60L);
                        if (Boolean.TRUE.equals(expire)) {
                            SnowflakeIdGenerator.this.heartBeatFailCount.set(0);
                        } else {
                            SnowflakeIdGenerator.this.workerId = null;
                        }
                    }
                    catch (Exception e) {
                        SnowflakeIdGenerator.this.logger.error(e.getMessage(), (Throwable)e);
                        if (SnowflakeIdGenerator.this.heartBeatFailCount.incrementAndGet() < SnowflakeIdGenerator.this.maxHeartBeatFailTimes) break block8;
                        SnowflakeIdGenerator.this.workerId = null;
                        SnowflakeIdGenerator.this.heartBeatFailCount.set(0);
                    }
                }
            }
            if (SnowflakeIdGenerator.this.executorService != null) {
                try {
                    SnowflakeIdGenerator.this.executorService.schedule(new BeatTask(), (long)SnowflakeIdGenerator.this.snowflakeProperties.getRedisHeartBeatMinutes(), TimeUnit.MINUTES);
                }
                catch (Exception e) {
                    SnowflakeIdGenerator.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

