/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.controller;

import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.controller.BaseVoController;
import com.cyberway.msf.commons.base.service.BaseService;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.core.exception.BusinessPreconditions;
import com.cyberway.msf.commons.model.base.EntityImpl;
import com.cyberway.msf.commons.model.base.vo.BaseNameVo;
import com.cyberway.msf.commons.model.filter.FilterModel;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.cyberway.msf.commons.model.valid.Insert;
import com.cyberway.msf.commons.model.valid.UpdateAll;
import com.cyberway.msf.commons.model.valid.UpdateSelected;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import springfox.documentation.annotations.ApiIgnore;

public class BaseController<T extends EntityImpl<Long>>
extends BaseVoController<T> {
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u8be6\u60c5", nickname="default_op")
    @GetMapping(value={"/{id}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", paramType="path", required=true, dataType="long", example="0")})
    public ApiResponseResult<T> selectById(@PathVariable Long id) {
        return this.getById(id, this.baseServiceImpl);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5217\u8868", nickname="default_op")
    @PostMapping(value={"/list"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="filterModel", value="\u5206\u9875", paramType="body", required=true, dataType="FilterModel")})
    public ApiResponseResult<PageDataModel<T>> list(@RequestBody FilterModel filterModel) {
        PageDataModel pageDataModel = this.baseServiceImpl.selectByFiltersPaging(filterModel);
        return new ApiResponseResult(ApiResultCode.SUCCESS, pageDataModel);
    }

    @ApiOperation(value="\u65b0\u589e\u5b9e\u4f53", nickname="default_op")
    @PostMapping
    public ApiResponseResult<Long> insert(@RequestBody @Validated(value={Insert.class}) @Valid T entity) {
        return this.insert(entity, this.baseServiceImpl);
    }

    @ApiOperation(value="\u4fee\u6539\u5b9e\u4f53,\u53ea\u66f4\u65b0\u5c5e\u6027\u4e0d\u4e3anull\u7684\u5b57\u6bb5", nickname="default_op")
    @PutMapping(value={"/{id}"})
    public ApiResponseResult<Integer> update(@PathVariable Long id, @RequestBody @Validated(value={UpdateSelected.class}) @Valid T entity) {
        return this.update(id, entity, this.baseServiceImpl);
    }

    @ApiOperation(value="\u4fee\u6539\u5b9e\u4f53,\u4fee\u6539\u5168\u90e8\u5c5e\u6027", nickname="default_op")
    @PutMapping(value={"/updateAll/{id}"})
    public ApiResponseResult<Integer> updateAll(@PathVariable Long id, @RequestBody @Validated(value={UpdateAll.class}) @Valid T entity) {
        if (id == null) {
            throw MessageUtils.buildException(ApiResultCode.PARAM_IS_NULL, "id");
        }
        entity.setId((Serializable)id);
        int sum = this.baseServiceImpl.updateAll(entity);
        if (sum > 0) {
            return new ApiResponseResult((Object)sum);
        }
        throw MessageUtils.buildException(ApiResultCode.UPDATE_DATA_FAIL, new Object[0]);
    }

    @ApiIgnore
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u7b80\u5355\u5bf9\u8c61", nickname="default_op")
    @GetMapping(value={"/nameVo/{id}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", paramType="path", required=true, dataType="long")})
    public ApiResponseResult<BaseNameVo> selectBaseNameVoById(@PathVariable(value="id") Long id) {
        return this.selectBaseNameVoById(id, "name");
    }

    @ApiIgnore
    @ApiOperation(value="\u6839\u636eids\u67e5\u8be2\u7b80\u5355\u5bf9\u8c61", nickname="default_op")
    @PostMapping(value={"/nameVo"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="ids", paramType="body", allowMultiple=true, required=true, dataType="long")})
    public ApiResponseResult<List<BaseNameVo>> selectBaseNameVoByIds(@RequestBody List<Long> ids) {
        return this.selectBaseNameVoByIds(ids, "name");
    }

    @ApiIgnore
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u7b80\u5355\u5bf9\u8c61", nickname="default_op")
    @GetMapping(value={"/nameVo/{id}/{field}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", paramType="path", required=true, dataType="long"), @ApiImplicitParam(name="field", value="\u6307\u5b9a\u540d\u79f0\u5b57\u6bb5", paramType="path", required=true, dataType="string")})
    public ApiResponseResult<BaseNameVo> selectBaseNameVoById(@PathVariable(value="id") Long id, @PathVariable(value="field") String field) {
        BusinessPreconditions.checkArgument((id != null ? 1 : 0) != 0, (BaseException)MessageUtils.buildException(ApiResultCode.PARAM_IS_NULL, "id"));
        BaseNameVo vo = this.baseServiceImpl.selectBaseNameVoById(id, field);
        return new ApiResponseResult(ApiResultCode.SUCCESS, (Object)vo);
    }

    @ApiIgnore
    @ApiOperation(value="\u6839\u636eids\u67e5\u8be2\u7b80\u5355\u5bf9\u8c61", nickname="default_op")
    @PostMapping(value={"/nameVo/{field}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="ids", paramType="body", allowMultiple=true, required=true, dataType="long"), @ApiImplicitParam(name="field", value="\u6307\u5b9a\u540d\u79f0\u5b57\u6bb5", paramType="path", required=true, dataType="string")})
    public ApiResponseResult<List<BaseNameVo>> selectBaseNameVoByIds(@RequestBody List<Long> ids, @PathVariable(value="field") String field) {
        if (CollectionUtils.isEmpty(ids)) {
            throw MessageUtils.buildException(ApiResultCode.PARAM_IS_NULL, "ids");
        }
        List<BaseNameVo> vos = this.baseServiceImpl.selectBaseNameVoByIds(ids, field);
        return new ApiResponseResult(ApiResultCode.SUCCESS, vos);
    }

    protected ApiResponseResult<T> getById(Long id, BaseService<T> baseServiceImpl) {
        BusinessPreconditions.checkArgument((id != null ? 1 : 0) != 0, (BaseException)MessageUtils.buildException(ApiResultCode.PARAM_IS_NULL, "id"));
        Object entity = baseServiceImpl.selectById(id);
        if (null != entity) {
            return new ApiResponseResult(ApiResultCode.SUCCESS, entity);
        }
        throw MessageUtils.buildException(ApiResultCode.GET_DATA_NOT_EXIST, id);
    }

    protected ApiResponseResult<List<T>> selectByFilters(FilterModel filterModel, BaseService<T> baseServiceImpl) {
        BusinessPreconditions.checkArgument((filterModel != null ? 1 : 0) != 0, (BaseException)MessageUtils.buildException(ApiResultCode.PARAM_IS_NULL, new Object[0]));
        List entities = baseServiceImpl.selectByFilters(filterModel);
        return new ApiResponseResult(ApiResultCode.SUCCESS, entities);
    }

    protected ApiResponseResult<Long> insert(T entity, BaseService<T> baseServiceImpl) {
        if (entity.getId() != null) {
            throw MessageUtils.buildException(ApiResultCode.PARAM_NOT_ALLOW, "id");
        }
        int sum = baseServiceImpl.insert(entity);
        if (sum > 0) {
            return new ApiResponseResult(ApiResultCode.SUCCESS, (Object)entity.getId());
        }
        throw MessageUtils.buildException(ApiResultCode.INSERT_DATA_FAIL, new Object[0]);
    }

    protected ApiResponseResult<Integer> update(Long id, T entity, BaseService<T> baseServiceImpl) {
        if (id == null) {
            throw MessageUtils.buildException(ApiResultCode.PARAM_IS_NULL, "id");
        }
        entity.setId((Serializable)id);
        int sum = baseServiceImpl.updateSelective(entity);
        if (sum > 0) {
            return new ApiResponseResult((Object)sum);
        }
        throw MessageUtils.buildException(ApiResultCode.UPDATE_DATA_FAIL, new Object[0]);
    }
}

