/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.controller;

import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.support.constant.CommonsBaseConstants;
import com.cyberway.msf.commons.base.support.converter.ErrorCodeConverter;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.core.i18n.I18nUtils;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

public class BaseHandleExceptionController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String API_PREFIX = "/api/";
    @Autowired
    protected ErrorCodeConverter errorCodeConverter;
    @Autowired
    private I18nUtils i18nUtils;

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    protected Object exception(Exception exception, HttpServletRequest request, HttpServletResponse response) {
        this.logger.warn("got a Exception", (Throwable)exception);
        String message = "";
        String exceptionCode = "";
        int httpStatus = HttpStatus.INTERNAL_SERVER_ERROR.value();
        if (exception instanceof BaseException) {
            return this.handleBaseException((BaseException)exception, request, response);
        }
        if (exception instanceof MissingServletRequestParameterException) {
            return this.handleRequestParameterException((MissingServletRequestParameterException)exception, request, response);
        }
        if (exception instanceof HttpMessageNotReadableException) {
            httpStatus = HttpStatus.BAD_REQUEST.value();
            exceptionCode = ApiResultCode.REQUIRE_PARAM_IS_ERROR.getResultCode();
            message = MessageUtils.getErrorMessage(ApiResultCode.REQUIRE_PARAM_IS_ERROR, new Object[0]);
        } else if (exception instanceof DataIntegrityViolationException) {
            exceptionCode = ApiResultCode.REFERENCE_DATA_ERROR.getResultCode();
            message = MessageUtils.getErrorMessage(ApiResultCode.REFERENCE_DATA_ERROR, new Object[0]);
        } else {
            if (exception instanceof MethodArgumentNotValidException) {
                return this.handleMethodArgumentNotValidException((MethodArgumentNotValidException)exception, request, response);
            }
            if (exception instanceof BadSqlGrammarException) {
                return this.handleBadSqlGrammarException((BadSqlGrammarException)exception, request, response, httpStatus);
            }
            if (exception instanceof MethodArgumentTypeMismatchException) {
                httpStatus = HttpStatus.BAD_REQUEST.value();
                MethodArgumentTypeMismatchException methodArgumentTypeMismatchException = (MethodArgumentTypeMismatchException)exception;
                exceptionCode = "00035";
                Object[] errorArgs = new Object[]{ObjectUtils.nullSafeToString((Object)methodArgumentTypeMismatchException.getValue()), ClassUtils.getDescriptiveType((Object)methodArgumentTypeMismatchException.getValue()), methodArgumentTypeMismatchException.getRequiredType() != null ? ClassUtils.getQualifiedName((Class)methodArgumentTypeMismatchException.getRequiredType()) : ""};
                message = "\u7c7b\u578b\u8f6c\u6362\u9519\u8bef\uff0c" + errorArgs[0] + "\u65e0\u6cd5\u4ece" + errorArgs[1] + "\u8f6c\u6362" + (methodArgumentTypeMismatchException.getRequiredType() != null ? "\u6210" + errorArgs[2] : "");
                message = MessageUtils.getErrorMessage(new ApiResultCode(exceptionCode, message), errorArgs);
            } else if (exception instanceof ConversionFailedException) {
                httpStatus = HttpStatus.BAD_REQUEST.value();
                ConversionFailedException conversionFailedException = (ConversionFailedException)exception;
                exceptionCode = "00035";
                Object[] errorArgs = new Object[]{ObjectUtils.nullSafeToString((Object)conversionFailedException.getValue()), conversionFailedException.getSourceType(), conversionFailedException.getTargetType()};
                message = "\u7c7b\u578b\u8f6c\u6362\u9519\u8bef\uff0c" + errorArgs[0] + "\u65e0\u6cd5\u4ece" + errorArgs[1] + "\u8f6c\u6362\u6210" + errorArgs[2];
                message = MessageUtils.getErrorMessage(new ApiResultCode(exceptionCode, message), errorArgs);
            } else {
                this.logger.error(exception.getMessage(), (Throwable)exception);
                exceptionCode = ApiResultCode.UNKNOWN_SYSTEM_ERROR.getResultCode();
                message = message + MessageUtils.getErrorMessage(ApiResultCode.UNKNOWN_SYSTEM_ERROR, new Object[0]);
            }
        }
        if (StringUtils.isBlank((CharSequence)exceptionCode)) {
            exceptionCode = ApiResultCode.UNKNOWN_SYSTEM_ERROR.getResultCode();
        }
        return this.buildReturn(request, response, exceptionCode, message, httpStatus);
    }

    private Object handleBadSqlGrammarException(BadSqlGrammarException exception, HttpServletRequest request, HttpServletResponse response, int httpStatus) {
        String exceptionCode = "";
        String message = "";
        SQLException sqlException = exception.getSQLException();
        String defaultMessage = sqlException.getMessage();
        if (CommonsBaseConstants.SORT_STRING_ERROR_PATTERN.matcher(defaultMessage).matches()) {
            String sort = StringUtils.substringAfter((String)StringUtils.substringBeforeLast((String)defaultMessage, (String)"' in 'order clause'"), (String)"Unknown column '");
            exceptionCode = ApiResultCode.SORT_STRING_ERROR.getResultCode();
            message = message + MessageUtils.getErrorMessage(ApiResultCode.SORT_STRING_ERROR, sort);
        } else {
            exceptionCode = ApiResultCode.BAD_SQL_GRAMMAR.getResultCode();
            message = message + MessageUtils.getErrorMessage(ApiResultCode.BAD_SQL_GRAMMAR, new Object[0]);
        }
        return this.buildReturn(request, response, exceptionCode, message, httpStatus);
    }

    private Object handleMethodArgumentNotValidException(MethodArgumentNotValidException exception, HttpServletRequest request, HttpServletResponse response) {
        FieldError error = exception.getBindingResult().getFieldError();
        String code = "";
        String exceptionCode = "";
        String message = "";
        int httpStatus = HttpStatus.BAD_REQUEST.value();
        if (null != error) {
            switch (code = code + error.getCode()) {
                case "NotBlank": 
                case "NotEmpty": 
                case "NotNull": 
                case "NullOrNotBlank": {
                    exceptionCode = ApiResultCode.PARAM_IS_NULL.getResultCode();
                    message = MessageUtils.getErrorMessage(ApiResultCode.PARAM_IS_NULL, error.getField());
                    break;
                }
                case "Phone": {
                    exceptionCode = ApiResultCode.CUSTOMIZE_ERROR.getResultCode();
                    message = MessageUtils.getErrorMessage(ApiResultCode.CUSTOMIZE_ERROR, "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u53f7\u7801");
                    break;
                }
                case "Email": {
                    exceptionCode = ApiResultCode.CUSTOMIZE_ERROR.getResultCode();
                    message = MessageUtils.getErrorMessage(ApiResultCode.CUSTOMIZE_ERROR, "\u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684\u7535\u5b50\u90ae\u4ef6\u5730\u5740");
                    break;
                }
                default: {
                    String fieldName = this.getErrorFieldName(error);
                    exceptionCode = ApiResultCode.INVALID_PARAM_VALUE.getResultCode();
                    message = MessageUtils.getErrorMessage(ApiResultCode.INVALID_PARAM_VALUE, fieldName, error.getDefaultMessage());
                    break;
                }
            }
        } else {
            exceptionCode = ApiResultCode.INVALID_PARAM_ERROR.getResultCode();
            message = MessageUtils.getErrorMessage(ApiResultCode.INVALID_PARAM_ERROR, new Object[0]);
        }
        return this.buildReturn(request, response, exceptionCode, message, httpStatus);
    }

    private String getErrorFieldName(FieldError error) {
        String field = error.getField();
        if (ArrayUtils.isNotEmpty((Object[])error.getCodes())) {
            String key = error.getCodes()[0];
            if (StringUtils.contains((CharSequence)key, (CharSequence)"[") && error.getCodes().length > 1) {
                key = error.getCodes()[1];
            }
            key = key + ".fieldName";
            String fieldName = MessageUtils.getErrorMessage(key, field, new Object[0]);
            return (String)StringUtils.defaultIfBlank((CharSequence)fieldName, (CharSequence)field);
        }
        return field;
    }

    private Object buildReturn(HttpServletRequest request, HttpServletResponse response, String exceptionCode, String message, int httpStatus) {
        response.setStatus(httpStatus);
        if (this.isApiRequest(request)) {
            return new ApiResponseResult(exceptionCode, message);
        }
        return String.format("%s:%s", exceptionCode, message);
    }

    private Object handleRequestParameterException(MissingServletRequestParameterException exception, HttpServletRequest request, HttpServletResponse response) {
        String exceptionCode = ApiResultCode.REQUIRE_PARAM_IS_NOT_PRESENT.getResultCode();
        int httpStatus = HttpStatus.BAD_REQUEST.value();
        String message = MessageUtils.getErrorMessage(ApiResultCode.REQUIRE_PARAM_IS_NOT_PRESENT, exception.getParameterType(), exception.getParameterName());
        return this.buildReturn(request, response, exceptionCode, message, httpStatus);
    }

    private Object handleBaseException(BaseException baseException, HttpServletRequest request, HttpServletResponse response) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(baseException.getMessage(), (Throwable)baseException);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("Request [{}] throw a BaseException:{}", (Object)request.getRequestURI(), (Object)baseException.getMessage());
        }
        response.setStatus(this.errorCodeConverter.convertErrorCodeToHttpStatus(baseException.getCode()));
        String message = StringUtils.isNotBlank((CharSequence)baseException.getCode()) ? this.i18nUtils.getMessage(baseException.getCode(), baseException.getMessage(), request, baseException.getValues()) : (baseException.getValues() == null ? baseException.getMessage() : String.format(baseException.getMessage(), baseException.getValues()));
        String code = (String)StringUtils.defaultIfBlank((CharSequence)baseException.getCode(), (CharSequence)ApiResultCode.UNKNOWN_SYSTEM_ERROR.getResultCode());
        if (this.isApiRequest(request)) {
            if (ApiResultCode.IMPORT_EXCEL_FAIL.getResultCode().equals(code)) {
                return new ApiResponseResult(code, message, (Object)baseException.getValues());
            }
            return new ApiResponseResult(code, message);
        }
        return String.format("%s:%s", code, message);
    }

    protected boolean isApiRequest(HttpServletRequest request) {
        return StringUtils.contains((CharSequence)request.getRequestURI(), (CharSequence)API_PREFIX);
    }
}

