/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.service;

import com.cyberway.msf.commons.base.service.BaseEntityService;
import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.org.vo.organization.OrganizationFullVO;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class BaseEntityServiceImpl
implements BaseEntityService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected RestTemplate restTemplate;
    @Autowired
    protected CommonsBaseProperties commonsBaseProperties;

    @Override
    public UserInfo getLoggedInUser() {
        return UserUtils.getLoggedInUser();
    }

    @Override
    public Object getLoggedInUserVo() {
        return this.restTemplate.postForObject(this.commonsBaseProperties.getUrl().getLoggedInUser(), (Object)this.getHttpEntity(), Object.class, new Object[0]);
    }

    @Override
    public Long getOrgId() {
        return UserUtils.getOrgId();
    }

    @Override
    public OrganizationFullVO getOrg() {
        return (OrganizationFullVO)this.restTemplate.postForObject(this.commonsBaseProperties.getUrl().getOrg(), (Object)this.getHttpEntity(), OrganizationFullVO.class, new Object[0]);
    }

    @Override
    public OrganizationFullVO getOrg(Long orgId) {
        return (OrganizationFullVO)this.restTemplate.postForObject(this.commonsBaseProperties.getUrl().getOrgByOrgId(), (Object)this.getHttpEntity(), OrganizationFullVO.class, new Object[]{orgId});
    }

    private HttpEntity getHttpEntity() {
        HttpHeaders headers = new HttpHeaders();
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String key = (String)headerNames.nextElement();
                String value = request.getHeader(key);
                headers.add(key, value);
            }
        }
        return new HttpEntity((MultiValueMap)headers);
    }

    protected Integer getStructure() {
        return this.commonsBaseProperties.getStructure();
    }
}

