/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.annotation.log;

import com.cyberway.msf.commons.base.support.annotation.log.ExceptionLogContentHandler;
import com.cyberway.msf.commons.base.support.annotation.log.LogRequired;
import com.cyberway.msf.commons.base.support.annotation.log.NoLogExceptionLogContentHandler;
import com.cyberway.msf.commons.base.util.LogUtils;
import com.cyberway.msf.commons.model.user.UserInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LogAspect {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<Class<? extends ExceptionLogContentHandler>, ExceptionLogContentHandler> exceptionLogContentHandlerMap = new LinkedHashMap<Class<? extends ExceptionLogContentHandler>, ExceptionLogContentHandler>();

    @Pointcut(value="@annotation(com.cyberway.msf.commons.base.support.annotation.log.LogRequired)")
    public void log() {
    }

    @Around(value="log() && @annotation(logRequired)")
    public Object doAround(ProceedingJoinPoint pjp, LogRequired logRequired) throws Throwable {
        Object proceed = null;
        Throwable ex = null;
        try {
            proceed = pjp.proceed();
        }
        catch (Throwable t) {
            ex = t;
        }
        this.log(pjp, logRequired, proceed, ex);
        if (ex != null) {
            throw ex;
        }
        return proceed;
    }

    private void log(ProceedingJoinPoint pjp, LogRequired logRequired, Object proceed, Throwable ex) {
        try {
            String tag = logRequired.tag();
            String content = this.obtainContent(pjp, logRequired, proceed, ex);
            if (StringUtils.isNotBlank((CharSequence)content) || logRequired.logWhenContentEmpty()) {
                if (proceed != null && proceed instanceof UserInfo) {
                    UserInfo userInfo = (UserInfo)proceed;
                    LogUtils.log(content, tag, userInfo.getFullName(), (Long)userInfo.getId(), ex == null);
                } else {
                    LogUtils.log(content, tag, ex == null);
                }
            }
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    private String obtainContent(ProceedingJoinPoint pjp, LogRequired logRequired, Object proceed, Throwable ex) {
        String[] parameterNames;
        String content = StringUtils.trimToEmpty((String)logRequired.content());
        if (ex != null) {
            if (!logRequired.exceptionLogContentHandler().equals(NoLogExceptionLogContentHandler.class)) {
                content = this.obtainExceptionContent(pjp, logRequired, ex);
            } else if (StringUtils.isNotEmpty((CharSequence)logRequired.exceptionContent())) {
                content = StringUtils.trimToEmpty((String)logRequired.exceptionContent());
            } else if (StringUtils.isNotEmpty((CharSequence)content) && !StringUtils.contains((CharSequence)content, (CharSequence)("#" + logRequired.returnValueName()))) {
                content = content + "+' \u64cd\u4f5c\u5931\u8d25'";
            }
        }
        if (StringUtils.isEmpty((CharSequence)content)) {
            return content;
        }
        if (!StringUtils.startsWith((CharSequence)content, (CharSequence)"'") && !StringUtils.startsWith((CharSequence)content, (CharSequence)"#")) {
            content = StringUtils.wrap((String)content, (String)"'");
        }
        if (StringUtils.contains((CharSequence)content, (CharSequence)"'''")) {
            content = StringUtils.replace((String)content, (String)"'''", (String)"'");
        }
        StandardEvaluationContext context = new StandardEvaluationContext();
        if (pjp.getSignature() instanceof MethodSignature && (parameterNames = ((MethodSignature)pjp.getSignature()).getParameterNames()) != null && parameterNames.length > 0) {
            Object[] args = pjp.getArgs();
            for (int i = 0; i < parameterNames.length; ++i) {
                context.setVariable(parameterNames[i], args[i]);
            }
        }
        context.setVariable(logRequired.returnValueName(), proceed);
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression exp = parser.parseExpression(content);
        Object expValue = exp.getValue((EvaluationContext)context);
        return Objects.toString(expValue, "");
    }

    private String obtainExceptionContent(ProceedingJoinPoint pjp, LogRequired logRequired, Throwable ex) {
        try {
            Class<? extends ExceptionLogContentHandler> exceptionLogContentHandler = logRequired.exceptionLogContentHandler();
            if (!this.exceptionLogContentHandlerMap.containsKey(exceptionLogContentHandler)) {
                this.initExceptionLogContentHandler(exceptionLogContentHandler);
            }
            return this.exceptionLogContentHandlerMap.get(exceptionLogContentHandler).buildLogContent(ex, logRequired, pjp);
        }
        catch (Throwable throwable) {
            this.logger.warn(throwable.getMessage(), throwable);
            return null;
        }
    }

    private synchronized void initExceptionLogContentHandler(Class<? extends ExceptionLogContentHandler> clazz) throws IllegalAccessException, InstantiationException {
        if (!this.exceptionLogContentHandlerMap.containsKey(clazz)) {
            this.exceptionLogContentHandlerMap.put(clazz, clazz.newInstance());
        }
    }
}

