/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.configuration;

import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import com.cyberway.msf.commons.base.support.interceptor.MapperInterceptor;
import com.cyberway.msf.commons.base.support.interceptor.QueryInterceptor;
import com.cyberway.msf.commons.base.support.interceptor.TableMappingInterceptor;
import java.util.List;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class MybatisInterceptorsConfig
implements CommandLineRunner {
    private final List<SqlSessionFactory> sqlSessionFactoryList;
    private final CommonsBaseProperties commonsBaseProperties;

    public MybatisInterceptorsConfig(List<SqlSessionFactory> sqlSessionFactoryList, CommonsBaseProperties commonsBaseProperties) {
        this.sqlSessionFactoryList = sqlSessionFactoryList;
        this.commonsBaseProperties = commonsBaseProperties;
    }

    public void run(String ... args) {
        MapperInterceptor mapperInterceptor = new MapperInterceptor();
        QueryInterceptor queryInterceptor = new QueryInterceptor(Boolean.TRUE.equals(this.commonsBaseProperties.getColumnNameUnderscore()));
        TableMappingInterceptor tableMappingInterceptor = new TableMappingInterceptor(this.commonsBaseProperties);
        for (SqlSessionFactory sqlSessionFactory : this.sqlSessionFactoryList) {
            sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)mapperInterceptor);
            sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)queryInterceptor);
            sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)tableMappingInterceptor);
        }
    }
}

