/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.xss;

import com.cyberway.msf.commons.base.support.xss.XssHolder;
import com.cyberway.msf.commons.base.support.xss.XssProperties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class XssCleanInterceptor
extends HandlerInterceptorAdapter {
    private final XssProperties xssProperties;

    public XssCleanInterceptor(XssProperties xssProperties) {
        this.xssProperties = xssProperties;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        if (!this.xssProperties.isEnabled()) {
            return true;
        }
        String requestType = request.getHeader("Msf-Request-Type");
        if ("0".equals(requestType)) {
            return true;
        }
        XssHolder.setEnable();
        return true;
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        XssHolder.remove();
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        XssHolder.remove();
    }
}

