/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.xss;

import com.cyberway.msf.commons.base.support.xss.DefaultXssCleaner;
import com.cyberway.msf.commons.base.support.xss.FormXssClean;
import com.cyberway.msf.commons.base.support.xss.JacksonXssClean;
import com.cyberway.msf.commons.base.support.xss.XssCleanInterceptor;
import com.cyberway.msf.commons.base.support.xss.XssCleaner;
import com.cyberway.msf.commons.base.support.xss.XssHolder;
import com.cyberway.msf.commons.base.support.xss.XssProperties;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={XssProperties.class})
@ConditionalOnProperty(value={"commons.xss.enabled"}, havingValue="true", matchIfMissing=true)
public class XssConfiguration
implements WebMvcConfigurer {
    private final XssProperties xssProperties;

    public XssConfiguration(XssProperties xssProperties) {
        this.xssProperties = xssProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public XssCleaner xssCleaner() {
        return new DefaultXssCleaner(this.xssProperties);
    }

    @Bean
    public FormXssClean formXssClean(XssCleaner xssCleaner) {
        return new FormXssClean(xssCleaner);
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer xssJacksonCustomizer(XssCleaner xssCleaner) {
        return builder -> builder.deserializerByType(String.class, (JsonDeserializer)new JacksonXssClean(xssCleaner));
    }

    public void addInterceptors(InterceptorRegistry registry) {
        List<String> patterns = this.xssProperties.getPathPatterns();
        if (patterns.isEmpty()) {
            patterns.add("/**");
        }
        XssCleanInterceptor interceptor = new XssCleanInterceptor(this.xssProperties);
        registry.addInterceptor((HandlerInterceptor)interceptor).addPathPatterns(patterns).excludePathPatterns(this.xssProperties.getExcludePatterns()).order(Integer.MAX_VALUE);
    }

    @Bean
    public FeignXssAspect feignXssAspect() {
        return new FeignXssAspect();
    }

    @Aspect
    @Order(value=2147483547)
    public class FeignXssAspect {
        @Pointcut(value="@within(org.springframework.cloud.openfeign.FeignClient)")
        public void feignClientXssPointCut() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Around(value="feignClientXssPointCut()")
        public Object around(ProceedingJoinPoint point) throws Throwable {
            boolean xssEnabled = XssHolder.isEnabled();
            if (!xssEnabled) {
                return point.proceed();
            }
            try {
                XssHolder.remove();
                Object object = point.proceed();
                return object;
            }
            finally {
                XssHolder.setEnable();
            }
        }
    }
}

