/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.client.BaseClient;
import com.cyberway.msf.commons.model.base.vo.BaseNameVo;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiResultUtils {
    private static final Logger logger = LoggerFactory.getLogger(ApiResultUtils.class);

    private ApiResultUtils() {
    }

    public static <T> T data(ApiResponseResult<T> result, boolean check) {
        if (result == null) {
            return null;
        }
        if (check && !ApiResultCode.SUCCESS.getResultCode().equals(result.getResultCode())) {
            throw MessageUtils.buildException(result, new Object[0]);
        }
        return (T)result.getData();
    }

    public static <T> T data(ApiResponseResult<T> result) {
        return ApiResultUtils.data(result, false);
    }

    public static <T> T okData(ApiResponseResult<T> result) {
        return ApiResultUtils.data(result, true);
    }

    public static <T> T okNonNullData(ApiResponseResult<T> result) {
        T data = ApiResultUtils.data(result, true);
        if (Objects.isNull(data)) {
            throw MessageUtils.buildException(ApiResultCode.GET_DATA_NOT_EXIST, "");
        }
        return data;
    }

    public static <T> Optional<T> dataOptional(ApiResponseResult<T> result) {
        return Optional.ofNullable(ApiResultUtils.data(result));
    }

    public static <T> Optional<T> okDataOptional(ApiResponseResult<T> result) {
        return Optional.ofNullable(ApiResultUtils.okData(result));
    }

    public static <T> String defaultName(BaseClient<T> client, Long id) {
        return ApiResultUtils.dataOptional(ApiResultUtils.nonThrows(client).selectBaseNameVoById(id)).map(BaseNameVo::getName).orElse("");
    }

    public static <T> T nonThrows(T target) {
        Class<?> clazz = target.getClass();
        InvocationHandler invocationHandler = (proxy, method, args) -> {
            try {
                return method.invoke(target, args);
            }
            catch (InvocationTargetException ex) {
                logger.warn(ex.getTargetException().getMessage(), ex.getTargetException());
                return null;
            }
            catch (Throwable ex) {
                logger.warn(ex.getMessage(), ex);
                return null;
            }
        };
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), clazz.getInterfaces(), invocationHandler);
    }
}

