/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;

public class ConvertUtils {
    private static final ConversionService CONVERSION_SERVICE = new DefaultConversionService();

    public static <T> T convert(Object source, Class<T> targetType) {
        if (Objects.isNull(source) || source instanceof String && StringUtils.isBlank((CharSequence)((String)source))) {
            return null;
        }
        return (T)CONVERSION_SERVICE.convert(source, targetType);
    }

    public static Integer convertToInteger(Object source) {
        return ConvertUtils.convert(source, Integer.class);
    }

    public static Long convertToLong(Object source) {
        return ConvertUtils.convert(source, Long.class);
    }

    public static BigDecimal convertToBigDecimal(Object source) {
        return ConvertUtils.convert(source, BigDecimal.class);
    }

    public static Date convertToDate(Object source) {
        return ConvertUtils.convert(source, Date.class);
    }
}

