/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.model.page.Orders;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.cyberway.msf.commons.model.page.PageModel;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class PageUtils<T> {
    private PageUtils() {
    }

    public static void sortAndPagination(PageModel pageModel, String defaultSort, String defaultOrder) {
        List orders = Optional.ofNullable(pageModel.getOrders()).orElse(new ArrayList());
        if (PageUtils.pagination(pageModel) || CollectionUtils.isEmpty((Collection)orders)) {
            if (StringUtils.isNotBlank((CharSequence)defaultSort) && StringUtils.isNotBlank((CharSequence)defaultOrder)) {
                PageHelper.orderBy((String)(defaultSort + ' ' + defaultOrder));
            }
            return;
        }
        StringBuilder orderBy = new StringBuilder();
        PageUtils.getOrderString(orders, orderBy);
    }

    public static void sortAndPagination(PageModel pageModel) {
        PageUtils.sortAndPagination(pageModel, null, null);
    }

    public static void sortAndPagination(PageModel pageModel, String defaultSort, String defaultOrder, Class<?> clazz, String alias) {
        List orders = Optional.ofNullable(pageModel.getOrders()).orElse(new ArrayList());
        if ((PageUtils.pagination(pageModel) || CollectionUtils.isEmpty((Collection)pageModel.getOrders())) && StringUtils.isNotBlank((CharSequence)defaultSort) && StringUtils.isNotBlank((CharSequence)defaultOrder)) {
            orders.add(new Orders(defaultSort, defaultOrder));
        }
        if (CollectionUtils.isEmpty((Collection)orders)) {
            return;
        }
        StringBuilder orderBy = new StringBuilder();
        if (clazz != null) {
            String name = (String)StringUtils.defaultIfEmpty((CharSequence)alias, (CharSequence)clazz.getAnnotation(Table.class).name().toLowerCase());
            ArrayList<String> fieldList = new ArrayList<String>();
            while (clazz != null) {
                for (Field declaredField : clazz.getDeclaredFields()) {
                    fieldList.add(declaredField.getName());
                }
                clazz = clazz.getSuperclass();
            }
            PageUtils.getOrderString(orders, orderBy, name, fieldList);
        } else {
            PageUtils.getOrderString(orders, orderBy, alias);
        }
    }

    public static void sortAndPagination(PageModel pageModel, String defaultSort, String defaultOrder, Class<?> clazz) {
        PageUtils.sortAndPagination(pageModel, defaultSort, defaultOrder, clazz, null);
    }

    public static void sortAndPagination(PageModel pageModel, Class<?> clazz) {
        PageUtils.sortAndPagination(pageModel, null, null, clazz);
    }

    public static void sortAndPaginationWithAlias(PageModel pageModel, String alias) {
        PageUtils.sortAndPagination(pageModel, null, null, null, alias);
    }

    public static void sortAndPaginationWithDefaultSort(PageModel pageModel, Class<?> clazz) {
        PageUtils.sortAndPagination(pageModel, null, null, clazz, "this_");
    }

    public static void sortAndPagination(PageModel pageModel, String orderBy) {
        if (PageUtils.pagination(pageModel)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)orderBy)) {
            return;
        }
        PageHelper.orderBy((String)orderBy);
    }

    private static void getOrderString(List<Orders> orders, StringBuilder orderBy, String name, List<String> fieldList) {
        for (Orders order : orders) {
            if (StringUtils.isEmpty((CharSequence)order.getSort()) || StringUtils.isEmpty((CharSequence)order.getOrder())) continue;
            PageUtils.sqlValidate(order.getSort(), order.getOrder());
            if (StringUtils.isNotEmpty((CharSequence)name) && (fieldList == null || fieldList.contains(order.getSort())) && !StringUtils.contains((CharSequence)order.getSort(), (CharSequence)".")) {
                orderBy.append(name).append('.');
            }
            orderBy.append(order.getSort()).append(' ').append(order.getOrder()).append(",");
        }
        PageHelper.orderBy((String)StringUtils.removeEnd((String)orderBy.toString(), (String)","));
    }

    private static void getOrderString(List<Orders> orders, StringBuilder orderBy, String name) {
        PageUtils.getOrderString(orders, orderBy, name, null);
    }

    private static void getOrderString(List<Orders> orders, StringBuilder orderBy) {
        PageUtils.getOrderString(orders, orderBy, null);
    }

    public static <T> PageDataModel<T> getPageDataModel(PageModel pageModel, Collection<T> rows) {
        if (null == pageModel) {
            return new PageDataModel(rows);
        }
        if (null != pageModel.getPageNum() && null != pageModel.getPageSize()) {
            try {
                if (rows instanceof Page) {
                    Page page = (Page)rows;
                    return new PageDataModel(rows, pageModel.getPageNum().intValue(), (int)page.getTotal(), pageModel.getPageSize().intValue());
                }
                return new PageDataModel(rows);
            }
            catch (Exception e) {
                throw new BaseException("Get PageDataModel fail.");
            }
        }
        return new PageDataModel(rows);
    }

    public static <T, K> PageDataModel<K> getPageDataModel(PageModel pageModel, PageDataModel<T> pageDataModel, List<K> list) {
        if (null == pageModel) {
            return new PageDataModel(list);
        }
        if (null != pageModel.getPageNum() && null != pageModel.getPageSize()) {
            return new PageDataModel(list, pageModel.getPageNum().intValue(), pageDataModel.getTotal().intValue(), pageModel.getPageSize().intValue());
        }
        return new PageDataModel(list);
    }

    private static boolean pagination(PageModel pageModel) {
        if (null == pageModel) {
            PageHelper.startPage((Object)0);
            return true;
        }
        if (null == pageModel.getPageNum() && null != pageModel.getPageSize()) {
            pageModel.setPageNum(Integer.valueOf(0));
        }
        if (null != pageModel.getPageNum() && null != pageModel.getPageSize()) {
            PageHelper.startPage((int)pageModel.getPageNum(), (int)pageModel.getPageSize());
        }
        return false;
    }

    public static void sqlValidate(String sort, String order) {
        Boolean sortValidate = !sort.trim().contains(" ") && !sort.contains(";");
        Boolean orderValidate = "asc".equalsIgnoreCase(order) || "desc".equalsIgnoreCase(order);
        if (sortValidate.booleanValue() && orderValidate.booleanValue()) {
            return;
        }
        throw MessageUtils.buildException(ApiResultCode.SORT_STRING_ERROR, sort + ' ' + order);
    }
}

