/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.annotation.log;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

public class LogApplicationListener
implements ApplicationListener<ApplicationEvent> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static boolean LOG_START;
    private static boolean LOG_STOP;

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationReadyEvent) {
            ApplicationReadyEvent readyEvent = (ApplicationReadyEvent)event;
            if (readyEvent.getApplicationContext().getParent() != null && !LOG_START) {
                this.log((ApplicationContext)readyEvent.getApplicationContext(), "\u542f\u52a8");
                LOG_START = true;
            }
        } else if (event instanceof ContextClosedEvent) {
            ContextClosedEvent closedEvent = (ContextClosedEvent)event;
            if (!LOG_STOP) {
                this.log(closedEvent.getApplicationContext(), "\u505c\u6b62");
            }
            LOG_STOP = true;
        }
    }

    private void log(ApplicationContext applicationContext, String type) {
        try {
            String appName = applicationContext.getEnvironment().getProperty("spring.application.name");
            this.logger.warn("\u5e94\u7528[" + appName + "]" + type + "\u6210\u529f");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

