/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.configuration;

import com.cyberway.msf.commons.base.util.MqUtils;
import com.cyberway.msf.commons.base.util.MsUtils;
import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.mq.interceptor.FrameworkEventInterceptor;
import com.cyberway.msf.mq.model.FrameworkEvent;
import com.cyberway.msf.mq.service.FrameworkEventService;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={FrameworkEventService.class})
public class MsConfig {
    @Bean
    @ConditionalOnMissingBean(value={MqUtils.class})
    public MqUtils mqUtils() {
        return new MqUtils();
    }

    @Bean
    @ConditionalOnMissingBean(value={MsUtils.class})
    public MsUtils msUtils() {
        return new MsUtils();
    }

    @Bean
    public TokenSetterInterceptor tokenSetterInterceptor() {
        return new TokenSetterInterceptor();
    }

    @Bean
    public TokenResetInterceptor tokenResetInterceptor() {
        return new TokenResetInterceptor();
    }

    static class TokenSetterInterceptor
    implements FrameworkEventInterceptor {
        TokenSetterInterceptor() {
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }

        public void executeSendBefore(FrameworkEvent frameworkEvent) {
            if (!frameworkEvent.getAllMetaData().containsKey("Authorization")) {
                UserInfo userInfo = UserUtils.getLoggedInUser();
                if (Objects.nonNull(userInfo) && Objects.nonNull(userInfo.getId())) {
                    userInfo = UserUtils.getAnonymousUser(userInfo.getTenantId(), userInfo.getOrgId(), userInfo.getTenantCode());
                }
                if (Objects.nonNull(userInfo)) {
                    frameworkEvent.setMetaData("Authorization", userInfo.getToken());
                }
            }
        }

        public void executeConsumeBefore(FrameworkEvent frameworkEvent) {
            String token = frameworkEvent.getMetaData("Authorization");
            if (StringUtils.isNotBlank((CharSequence)token)) {
                UserInfo userInfo = UserUtils.getUserInfoByToken(token);
                UserUtils.setLocalUserInfo(userInfo, true);
            }
        }
    }

    static class TokenResetInterceptor
    implements FrameworkEventInterceptor {
        TokenResetInterceptor() {
        }

        public int getOrder() {
            return Integer.MAX_VALUE;
        }

        public void executeConsumeAfter(FrameworkEvent frameworkEvent) {
            UserUtils.resetLocalUserInfo();
        }
    }
}

