/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.interceptor;

import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.google.common.collect.Lists;
import feign.RequestInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class FeignInterceptor {
    private static final List<String> IGNORE_HEADERS = Arrays.asList("content-type", "content-length", "accept", "accept-encoding", "accept-language", "connection", "sec-fetch-dest", "sec-fetch-mode", "sec-fetch-site", "dnt");

    @Bean
    public RequestInterceptor requestInterceptor() {
        return template -> {
            UserInfo userInfo;
            HttpServletRequest request;
            Enumeration headerNames;
            Set<String> names = template.headers().keySet().stream().map(String::toLowerCase).collect(Collectors.toSet());
            LinkedHashMap<String, ArrayList> addHeaders = new LinkedHashMap<String, ArrayList>();
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (attributes != null && (headerNames = (request = attributes.getRequest()).getHeaderNames()) != null) {
                while (headerNames.hasMoreElements()) {
                    String values;
                    String name = (String)headerNames.nextElement();
                    if (this.ignoreHeaders(name, names, values = request.getHeader(name))) continue;
                    addHeaders.put(name, Lists.newArrayList((Object[])new String[]{values}));
                    names.add(name);
                }
            }
            if (!names.contains("Authorization".toLowerCase()) && null != (userInfo = UserUtils.getLoggedInUser()) && StringUtils.isNotBlank((CharSequence)userInfo.getToken())) {
                addHeaders.put("Authorization", Lists.newArrayList((Object[])new String[]{userInfo.getToken()}));
            }
            addHeaders.put("Msf-Request-Type", Lists.newArrayList((Object[])new String[]{"0"}));
            template.headers(addHeaders);
        };
    }

    private boolean ignoreHeaders(String headerName, Set<String> headerNames, String value) {
        String name = headerName.toLowerCase();
        return IGNORE_HEADERS.contains(name) || headerNames.contains(name) || StringUtils.isBlank((CharSequence)value);
    }
}

