/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.multitable;

import com.cyberway.msf.commons.base.support.multitable.MultiSqls;
import com.cyberway.msf.commons.base.support.multitable.MultiTableResultCode;
import com.cyberway.msf.commons.base.support.provider.BaseExample;
import com.cyberway.msf.commons.base.support.provider.CustomSqlHelper;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.entity.Example;

public class MultiTableExample
extends BaseExample {
    private static final Logger logger = LoggerFactory.getLogger(MultiTableExample.class);
    private boolean leftJoinFlag = false;
    private List<String> associatedTableAlias = new ArrayList<String>();
    private List<String> associatedTableNames = new ArrayList<String>();
    private Map<String, String> associatedMap = new HashMap<String, String>();
    private List<String> leftJoinOns = new ArrayList<String>();
    private Map<String, String> leftJoinOnsMap = new HashMap<String, String>();

    public MultiTableExample(Class<?> entityClass) {
        super(entityClass);
    }

    public MultiTableExample(Class<?> entityClass, boolean exists) {
        super(entityClass, exists);
    }

    public MultiTableExample(Class<?> entityClass, boolean exists, boolean notNull) {
        super(entityClass, exists, notNull);
    }

    @Override
    public void end() throws BaseException {
        super.end();
    }

    @Override
    public MultiTableExample addLeftJoin(MultiSqls multiSqls) {
        if (multiSqls == null) {
            throw MessageUtils.buildException(MultiTableResultCode.EMPTY_ASSOCIATED_EXPRESSION, new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)multiSqls.getAssociatedTableName()) && StringUtils.isEmpty((CharSequence)multiSqls.getAssociatedTableAlias())) {
            throw MessageUtils.buildException(MultiTableResultCode.EMPTY_ASSOCIATED_TABLE, new Object[0]);
        }
        this.leftJoinFlag = true;
        this.associatedTableNames.add(multiSqls.getAssociatedTableName());
        this.associatedTableAlias.add(multiSqls.getAssociatedTableAlias());
        this.associatedMap.put(multiSqls.getAssociatedTableAlias(), multiSqls.getAssociatedTableName());
        if (StringUtils.isEmpty((CharSequence)multiSqls.getProperty()) && StringUtils.isEmpty((CharSequence)multiSqls.getAssociatedProperty())) {
            throw MessageUtils.buildException(MultiTableResultCode.EMPTY_ON_EXPRESSION, new Object[0]);
        }
        StringBuilder sql = new StringBuilder();
        sql.append(multiSqls.getAssociatedTableAlias().trim()).append(".").append(multiSqls.getAssociatedProperty());
        sql.append(" = ");
        sql.append(this.getTableAlias() != null ? this.getTableAlias().trim() : CustomSqlHelper.getDefaultAlias(this.entityClass).trim()).append(".").append(multiSqls.getProperty());
        this.leftJoinOns.add(sql.toString());
        this.leftJoinOnsMap.put(multiSqls.getAssociatedTableAlias(), sql.toString());
        return this;
    }

    public boolean isLeftJoinFlag() {
        return this.leftJoinFlag;
    }

    public List<String> getLeftJoinOns() {
        return this.leftJoinOns;
    }

    public List<String> getAssociatedTableNames() {
        return this.associatedTableNames;
    }

    public List<String> getAssociatedTableAlias() {
        return this.associatedTableAlias;
    }

    public Map<String, String> getAssociatedMap() {
        return this.associatedMap;
    }

    public Map<String, String> getLeftJoinOnsMap() {
        return this.leftJoinOnsMap;
    }

    public MultiTableCriteria createMultiTableCriteria() {
        MultiTableCriteria criteria = this.createMultiTableCriteriaInternal();
        if (this.oredCriteria.size() == 0) {
            criteria.setAndOr("and");
            this.oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected MultiTableCriteria createMultiTableCriteriaInternal() {
        MultiTableCriteria criteria = new MultiTableCriteria(this.propertyMap, this.exists, this.notNull);
        return criteria;
    }

    public static class MultiTableCriteria
    extends Example.Criteria {
        protected MultiTableCriteria(Map<String, EntityColumn> propertyMap, boolean exists, boolean notNull) {
            super(propertyMap, exists, notNull);
        }

        private String column(String property) {
            return property;
        }

        private String property(String property) {
            return property;
        }

        public Example.Criteria andIsNull(String property) {
            this.addCriterion(this.column(property) + " is null");
            return this;
        }

        public Example.Criteria andIsNotNull(String property) {
            this.addCriterion(this.column(property) + " is not null");
            return this;
        }

        public Example.Criteria andEqualTo(String property, Object value) {
            this.addCriterion(this.column(property) + " =", value, this.property(property));
            return this;
        }

        public Example.Criteria andNotEqualTo(String property, Object value) {
            this.addCriterion(this.column(property) + " <>", value, this.property(property));
            return this;
        }

        public Example.Criteria andGreaterThan(String property, Object value) {
            this.addCriterion(this.column(property) + " >", value, this.property(property));
            return this;
        }

        public Example.Criteria andGreaterThanOrEqualTo(String property, Object value) {
            this.addCriterion(this.column(property) + " >=", value, this.property(property));
            return this;
        }

        public Example.Criteria andLessThan(String property, Object value) {
            this.addCriterion(this.column(property) + " <", value, this.property(property));
            return this;
        }

        public Example.Criteria andLessThanOrEqualTo(String property, Object value) {
            this.addCriterion(this.column(property) + " <=", value, this.property(property));
            return this;
        }

        public Example.Criteria andIn(String property, Iterable values) {
            this.addCriterion(this.column(property) + " in", values, this.property(property));
            return this;
        }

        public Example.Criteria andNotIn(String property, Iterable values) {
            this.addCriterion(this.column(property) + " not in", values, this.property(property));
            return this;
        }

        public Example.Criteria andBetween(String property, Object value1, Object value2) {
            this.addCriterion(this.column(property) + " between", value1, value2, this.property(property));
            return this;
        }

        public Example.Criteria andNotBetween(String property, Object value1, Object value2) {
            this.addCriterion(this.column(property) + " not between", value1, value2, this.property(property));
            return this;
        }

        public Example.Criteria andLike(String property, String value) {
            this.addCriterion(this.column(property) + "  like", value, this.property(property));
            return this;
        }

        public Example.Criteria andNotLike(String property, String value) {
            this.addCriterion(this.column(property) + "  not like", value, this.property(property));
            return this;
        }

        public Example.Criteria orIsNull(String property) {
            this.addOrCriterion(this.column(property) + " is null");
            return this;
        }

        public Example.Criteria orIsNotNull(String property) {
            this.addOrCriterion(this.column(property) + " is not null");
            return this;
        }

        public Example.Criteria orEqualTo(String property, Object value) {
            this.addOrCriterion(this.column(property) + " =", value, this.property(property));
            return this;
        }

        public Example.Criteria orNotEqualTo(String property, Object value) {
            this.addOrCriterion(this.column(property) + " <>", value, this.property(property));
            return this;
        }

        public Example.Criteria orGreaterThan(String property, Object value) {
            this.addOrCriterion(this.column(property) + " >", value, this.property(property));
            return this;
        }

        public Example.Criteria orGreaterThanOrEqualTo(String property, Object value) {
            this.addOrCriterion(this.column(property) + " >=", value, this.property(property));
            return this;
        }

        public Example.Criteria orLessThan(String property, Object value) {
            this.addOrCriterion(this.column(property) + " <", value, this.property(property));
            return this;
        }

        public Example.Criteria orLessThanOrEqualTo(String property, Object value) {
            this.addOrCriterion(this.column(property) + " <=", value, this.property(property));
            return this;
        }

        public Example.Criteria orIn(String property, Iterable values) {
            this.addOrCriterion(this.column(property) + " in", values, this.property(property));
            return this;
        }

        public Example.Criteria orNotIn(String property, Iterable values) {
            this.addOrCriterion(this.column(property) + " not in", values, this.property(property));
            return this;
        }

        public Example.Criteria orBetween(String property, Object value1, Object value2) {
            this.addOrCriterion(this.column(property) + " between", value1, value2, this.property(property));
            return this;
        }

        public Example.Criteria orNotBetween(String property, Object value1, Object value2) {
            this.addOrCriterion(this.column(property) + " not between", value1, value2, this.property(property));
            return this;
        }

        public Example.Criteria orLike(String property, String value) {
            this.addOrCriterion(this.column(property) + "  like", value, this.property(property));
            return this;
        }

        public Example.Criteria orNotLike(String property, String value) {
            this.addOrCriterion(this.column(property) + "  not like", value, this.property(property));
            return this;
        }
    }
}

