/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.provider;

import com.cyberway.msf.commons.base.support.interceptor.OrgFilter;
import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.model.annotation.AssociatedTable;
import com.cyberway.msf.commons.model.annotation.Protected;
import java.util.Set;
import javax.persistence.Column;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.SqlHelper;

public class CustomSqlHelper {
    private CustomSqlHelper() {
    }

    public static String selectOriginalColumns(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(CustomSqlHelper.getAllColumnsWithDefaultAlias(entityClass));
        sql.append(" ");
        return sql.toString();
    }

    public static String getAllColumnsWithDefaultAlias(Class<?> entityClass) {
        Set columnSet = EntityHelper.getColumns(entityClass);
        StringBuilder sql = new StringBuilder();
        for (EntityColumn entityColumn : columnSet) {
            sql.append(" ").append(CustomSqlHelper.getDefaultAlias(entityClass).trim()).append(".").append(entityColumn.getColumn()).append(",");
        }
        return sql.substring(0, sql.length() - 1);
    }

    public static String getAssociatedColumnsWithDefaultAlias(Class<?> entityClass) {
        Set columnSet = EntityHelper.getColumns(entityClass);
        StringBuilder sql = new StringBuilder(",");
        for (EntityColumn entityColumn : columnSet) {
            if (!entityColumn.getEntityField().isAnnotationPresent(AssociatedTable.class)) continue;
            AssociatedTable associatedTable = (AssociatedTable)entityColumn.getEntityField().getAnnotation(AssociatedTable.class);
            sql.append(" ").append(associatedTable.mappingField().trim()).append(".").append(associatedTable.associatedField()).append(" ").append(associatedTable.mappingField()).append(",");
        }
        return sql.length() == 1 ? "" : sql.substring(0, sql.length() - 1);
    }

    public static String getDefaultAlias(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder(" ");
        return sql.append(entityClass.getSimpleName()).append(" ").toString();
    }

    public static String leftJoinWithDefaultAlias(Class<?> entityClass, EntityColumn entityColumn, AssociatedTable associatedTable, String defaultTableName) {
        StringBuilder sql = new StringBuilder();
        sql.append(" LEFT JOIN ");
        sql.append(SqlHelper.getDynamicTableName((Class)associatedTable.associatedClass(), (String)defaultTableName));
        sql.append(" ");
        sql.append(associatedTable.mappingField().trim());
        sql.append(" ON ");
        Set columnSet = EntityHelper.getPKColumns((Class)associatedTable.associatedClass());
        sql.append(associatedTable.mappingField().trim()).append(".").append(((EntityColumn)columnSet.iterator().next()).getEntityField().getName());
        sql.append(" = ");
        sql.append(CustomSqlHelper.getDefaultAlias(entityClass).trim()).append(".").append(entityColumn.getEntityField().isAnnotationPresent(Column.class) ? ((Column)entityColumn.getEntityField().getAnnotation(Column.class)).name() : entityColumn.getEntityField().getName());
        return sql.toString();
    }

    public static String wherePKColumnsWithDefaultAlias(Class<?> entityClass) {
        return CustomSqlHelper.wherePKColumnsWithDefaultAlias(entityClass, false);
    }

    public static String wherePKColumnsWithDefaultAlias(Class<?> entityClass, boolean useVersion) {
        return CustomSqlHelper.wherePKColumnsWithDefaultAlias(entityClass, null, useVersion);
    }

    public static String wherePKColumnsWithDefaultAlias(Class<?> entityClass, String entityName, boolean useVersion) {
        StringBuilder sql = new StringBuilder();
        sql.append("<where>");
        Set columnSet = EntityHelper.getPKColumns(entityClass);
        for (EntityColumn column : columnSet) {
            sql.append(" AND ");
            sql.append(CustomSqlHelper.getDefaultAlias(entityClass).trim()).append(".");
            sql.append(column.getColumnEqualsHolder(entityName));
        }
        if (useVersion) {
            sql.append(SqlHelper.whereVersion(entityClass));
        }
        sql.append("</where>");
        return sql.toString();
    }

    public static String wherePKColumnsWithAlias(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"_parameter != null\">\n");
        sql.append("   ${@com.cyberway.msf.commons.base.support.provider.ExampleOgnl@andNotLogicDelete(_parameter)}\n");
        Set columnSet = EntityHelper.getPKColumns(entityClass);
        for (EntityColumn column : columnSet) {
            sql.append("${@com.cyberway.msf.commons.base.support.provider.ExampleOgnl@getTableAlias(_parameter)}").append(".");
            sql.append(column.getColumn());
            sql.append(" = ");
            sql.append("#{");
            sql.append("primaryKey");
            if (column.getJdbcType() != null) {
                sql.append(", jdbcType=");
                sql.append(column.getJdbcType().toString());
            }
            if (column.getTypeHandler() != null) {
                sql.append(", typeHandler=");
                sql.append(column.getTypeHandler().getCanonicalName());
            }
            sql.append("}");
        }
        sql.append("</if>\n");
        return sql.toString();
    }

    public static String whereLogicDelete(Class<?> entityClass, boolean isDeleted) {
        String value = SqlHelper.logicDeleteColumnEqualsValue(entityClass, (boolean)isDeleted);
        return "".equals(value) ? "" : " AND " + value;
    }

    public static String exampleSelectColumnsWithDefaultAlias(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<choose>");
        sql.append("<when test=\"@tk.mybatis.mapper.util.OGNL@hasSelectColumns(_parameter)\">");
        sql.append("<foreach collection=\"_parameter.selectColumns\" item=\"selectColumn\" open=\"");
        sql.append(CustomSqlHelper.getDefaultAlias(entityClass).trim()).append(".");
        sql.append("\" separator=\",");
        sql.append(CustomSqlHelper.getDefaultAlias(entityClass).trim()).append(".");
        sql.append("\">");
        sql.append("${selectColumn}");
        sql.append("</foreach>");
        sql.append("</when>");
        sql.append("<otherwise>");
        sql.append(CustomSqlHelper.getAllColumnsWithDefaultAlias(entityClass));
        sql.append(CustomSqlHelper.getAssociatedColumnsWithDefaultAlias(entityClass));
        sql.append("</otherwise>");
        sql.append("</choose>");
        return sql.toString();
    }

    public static String exampleWhereClause() {
        return "<if test=\"_parameter != null\">\n    ${@com.cyberway.msf.commons.base.support.provider.ExampleOgnl@andNotLogicDelete(_parameter)}\n    <trim prefix=\"(\" prefixOverrides=\"and |or \" suffix=\")\">\n    <foreach collection=\"oredCriteria\" item=\"criteria\">\n      <if test=\"criteria.valid\">\n        ${@tk.mybatis.mapper.util.OGNL@andOr(criteria)}        <trim prefix=\"(\" prefixOverrides=\"and |or \" suffix=\")\">\n        <foreach collection=\"criteria.criteria\" item=\"criterion\">\n          <choose>\n            <when test=\"criterion.noValue\">\n              ${@tk.mybatis.mapper.util.OGNL@andOr(criterion)} ${@com.cyberway.msf.commons.base.support.provider.ExampleOgnl@getPropertyPrefix(_parameter,criterion.condition)}\n            </when>\n            <when test=\"criterion.singleValue\">\n              ${@tk.mybatis.mapper.util.OGNL@andOr(criterion)} ${@com.cyberway.msf.commons.base.support.provider.ExampleOgnl@getPropertyPrefix(_parameter,criterion.condition)} #{criterion.value}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              ${@tk.mybatis.mapper.util.OGNL@andOr(criterion)} ${@com.cyberway.msf.commons.base.support.provider.ExampleOgnl@getPropertyPrefix(_parameter,criterion.condition)} #{criterion.value} and #{criterion.secondValue}\n            </when>\n            <when test=\"criterion.listValue\">\n              ${@tk.mybatis.mapper.util.OGNL@andOr(criterion)} ${@com.cyberway.msf.commons.base.support.provider.ExampleOgnl@getPropertyPrefix(_parameter,criterion.condition)}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\" open=\"(\" separator=\",\">\n                #{listItem}\n              </foreach>\n            </when>\n          </choose>\n        </foreach>\n        </trim>\n      </if>\n    </foreach>\n    </trim>\n</if>\n";
    }

    public static String isUseAlias(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("\n<choose>\n");
        sql.append("  <when test=\"@com.cyberway.msf.commons.base.support.provider.ExampleOgnl@useAlias(_parameter)\">\n");
        sql.append("    ${tableAlias}\n");
        sql.append("  </when>\n");
        sql.append("  <otherwise>\n");
        sql.append("    ").append(CustomSqlHelper.getDefaultAlias(entityClass).trim()).append("\n");
        sql.append("  </otherwise>\n");
        sql.append("</choose>\n");
        return sql.toString();
    }

    public static String isUseLeftJoin() {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"@com.cyberway.msf.commons.base.support.provider.ExampleOgnl@useMultiTableSelectAndLeftJoin(_parameter)\">\n");
        sql.append("  ${@com.cyberway.msf.commons.base.support.provider.ExampleOgnl@leftJoin(_parameter)}\n");
        sql.append("</if>\n");
        return sql.toString();
    }

    public static String exampleSelectColumns() {
        StringBuilder sql = new StringBuilder();
        sql.append("<choose>\n");
        sql.append("  <when test=\"@tk.mybatis.mapper.util.OGNL@hasSelectColumns(_parameter)\">\n");
        sql.append("    ${@com.cyberway.msf.commons.base.support.provider.ExampleOgnl@selectColumns(_parameter)}\n");
        sql.append("  </when>\n");
        sql.append("  <otherwise>\n");
        sql.append("    ${@com.cyberway.msf.commons.base.support.provider.ExampleOgnl@selectAllColumns(_parameter)}\n");
        sql.append("  </otherwise>\n");
        sql.append("</choose>\n");
        return sql.toString();
    }

    public static boolean hasProtectedColumn(Class<?> entityClass) {
        return CustomSqlHelper.getProtectedColumn(entityClass) != null;
    }

    public static EntityColumn getProtectedColumn(Class<?> entityClass) {
        EntityColumn protectedColumn = null;
        Set columnSet = EntityHelper.getColumns(entityClass);
        boolean hasProtected = false;
        for (EntityColumn column : columnSet) {
            if (!column.getEntityField().isAnnotationPresent(Protected.class)) continue;
            if (hasProtected) {
                throw new BaseException(entityClass.getCanonicalName() + " \u4e2d\u5305\u542b\u591a\u4e2a\u5e26\u6709 @Protected \u6ce8\u89e3\u7684\u5b57\u6bb5\uff0c\u4e00\u4e2a\u7c7b\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u5e26\u6709 @Protected \u6ce8\u89e3\u7684\u5b57\u6bb5!");
            }
            hasProtected = true;
            protectedColumn = column;
        }
        return protectedColumn;
    }

    public static String protectedColumnEqualsValue(Class<?> entityClass) {
        EntityColumn protectedColumn = CustomSqlHelper.getProtectedColumn(entityClass);
        if (protectedColumn != null) {
            return CustomSqlHelper.protectedColumnEqualsValue(protectedColumn);
        }
        return "";
    }

    public static String protectedColumnEqualsValue(EntityColumn column) {
        String result = "";
        if (column.getEntityField().isAnnotationPresent(Protected.class)) {
            result = column.getColumn() + " = " + CustomSqlHelper.getProtectedValue(column);
        }
        return result;
    }

    public static int getProtectedValue(EntityColumn column) {
        if (!column.getEntityField().isAnnotationPresent(Protected.class)) {
            throw new BaseException(column.getColumn() + " \u6ca1\u6709 @Protected \u6ce8\u89e3!");
        }
        Protected pro = (Protected)column.getEntityField().getAnnotation(Protected.class);
        return pro.notProtectedValue();
    }

    public static String orgWhereClause(OrgFilter orgFilter, Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        if (SqlHelper.hasLogicDeleteColumn(entityClass)) {
            sql.append(" and ");
        } else {
            sql.append("<if test=\"@com.cyberway.msf.commons.base.support.provider.ExampleOgnl@hasExample(_parameter)\">\n");
            sql.append(" and ");
            sql.append("</if>\n");
        }
        sql.append("${@com.cyberway.msf.commons.base.support.provider.ExampleOgnl@getTableAlias(_parameter)}").append(".");
        sql.append("tenantId = #_TENANTID");
        if (!orgFilter.tenantOnly()) {
            sql.append(" and ");
            sql.append("${@com.cyberway.msf.commons.base.support.provider.ExampleOgnl@getTableAlias(_parameter)}").append(".");
            sql.append("orgId = #_ORGID");
        }
        return sql.toString();
    }

    public static String orgWherePKClause(OrgFilter orgFilter, Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append(" and ");
        sql.append("${@com.cyberway.msf.commons.base.support.provider.ExampleOgnl@getTableAlias(_parameter)}").append(".");
        sql.append("tenantId = #_TENANTID");
        if (!orgFilter.tenantOnly()) {
            sql.append(" and ");
            sql.append("${@com.cyberway.msf.commons.base.support.provider.ExampleOgnl@getTableAlias(_parameter)}").append(".");
            sql.append("orgId = #_ORGID");
        }
        return sql.toString();
    }
}

