/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.xss;

import com.cyberway.msf.commons.base.support.xss.XssCleaner;
import com.cyberway.msf.commons.base.support.xss.XssHolder;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.InitBinder;

@ControllerAdvice
public class FormXssClean {
    private final XssCleaner xssCleaner;

    public FormXssClean(XssCleaner xssCleaner) {
        this.xssCleaner = xssCleaner;
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringPropertiesEditor(this.xssCleaner));
    }

    public static class StringPropertiesEditor
    extends PropertyEditorSupport {
        private final XssCleaner xssCleaner;

        public StringPropertiesEditor(XssCleaner xssCleaner) {
            this.xssCleaner = xssCleaner;
        }

        @Override
        public String getAsText() {
            Object value = this.getValue();
            return value != null ? value.toString() : "";
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            if (text == null) {
                this.setValue(null);
            } else if (XssHolder.isEnabled()) {
                String value = this.xssCleaner.clean(text);
                this.setValue(value);
            } else {
                this.setValue(text);
            }
        }
    }
}

