/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import com.cyberway.msf.commons.base.support.annotation.log.BusinessLogEvent;
import com.cyberway.msf.commons.base.support.annotation.log.DataChangeLogEvent;
import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import com.cyberway.msf.commons.base.util.IpUtils;
import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.log.model.AccessLog;
import com.cyberway.msf.log.model.BusinessLog;
import com.cyberway.msf.log.model.DataChangeLog;
import com.cyberway.msf.log.model.event.AccessLogEvent;
import com.cyberway.msf.mq.model.FrameworkEvent;
import com.cyberway.msf.mq.service.FrameworkEventService;
import java.util.Date;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class LogUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogUtils.class);
    private final FrameworkEventService frameworkEventService;
    private final CommonsBaseProperties commonsBaseProperties;
    private final Environment environment;
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private static LogUtils logUtils;

    public LogUtils(FrameworkEventService frameworkEventService, CommonsBaseProperties commonsBaseProperties, Environment environment) {
        this.frameworkEventService = frameworkEventService;
        this.commonsBaseProperties = commonsBaseProperties;
        this.environment = environment;
        this.threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        this.threadPoolTaskExecutor.afterPropertiesSet();
        logUtils = this;
    }

    public static void log(String content, String tag, String createBy, Long createById, Boolean success) {
        LogUtils.log(content, tag, createBy, createById, success, true);
    }

    public static void log(String content, String tag, String createBy, Long createById, Boolean success, boolean asyncSend) {
        block7: {
            if (logUtils == null || LogUtils.logUtils.commonsBaseProperties == null || !Boolean.TRUE.equals(LogUtils.logUtils.commonsBaseProperties.getLogEnable()) || LogUtils.logUtils.frameworkEventService == null) {
                return;
            }
            UserInfo userInfo = UserUtils.getLoggedInUser();
            try {
                String fromIp = "";
                ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                if (attributes != null) {
                    HttpServletRequest request = attributes.getRequest();
                    fromIp = IpUtils.getRemoteAddr(request);
                }
                BusinessLog log = new BusinessLog();
                log.setContent(content);
                log.setFromIp(fromIp);
                log.setCreateTime(new Date());
                log.setModule(tag);
                log.setSuccess(Boolean.valueOf(!Boolean.FALSE.equals(success)));
                log.setCreateBy(createBy);
                log.setCreateById(createById);
                if (createById == null) {
                    log.setCreateBy(userInfo == null ? null : userInfo.getFullName());
                    log.setCreateById(userInfo == null ? null : (Long)userInfo.getId());
                }
                BusinessLogEvent businessLogEvent = new BusinessLogEvent();
                businessLogEvent.setData(log);
                if (asyncSend) {
                    LogUtils.logUtils.threadPoolTaskExecutor.execute(() -> LogUtils.logUtils.frameworkEventService.pushEvent((FrameworkEvent)businessLogEvent));
                } else {
                    LogUtils.logUtils.frameworkEventService.pushEvent((FrameworkEvent)businessLogEvent);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block7;
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void log(String content, String tag, Boolean success) {
        LogUtils.log(content, tag, null, null, success);
    }

    public static void log(String content, String tag) {
        LogUtils.log(content, tag, null, null, true);
    }

    public static void logAccess(String logType, String content, boolean success, String logBy, String logById) {
        AccessLog accessLog = new AccessLog();
        accessLog.setLogType(logType);
        accessLog.setContent(content);
        accessLog.setLogBy(logBy);
        accessLog.setLogById(logById);
        accessLog.setSuccess(Boolean.valueOf(success));
        LogUtils.logAccess(accessLog);
    }

    public static void logAccess(AccessLog accessLog) {
        block15: {
            if (logUtils == null || LogUtils.logUtils.commonsBaseProperties == null || LogUtils.logUtils.frameworkEventService == null || LogUtils.logUtils.environment == null) {
                return;
            }
            String appName = LogUtils.logUtils.environment.getProperty("spring.application.name");
            if (StringUtils.isBlank((CharSequence)appName)) {
                return;
            }
            accessLog.setLogTime(new Date());
            String token = null;
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (attributes != null) {
                HttpServletRequest request = attributes.getRequest();
                if (StringUtils.isEmpty((CharSequence)accessLog.getFromIp())) {
                    accessLog.setFromIp(IpUtils.getRemoteAddr(request));
                }
                if (StringUtils.isEmpty((CharSequence)accessLog.getMethod())) {
                    accessLog.setMethod(request.getMethod());
                }
                if (StringUtils.isEmpty((CharSequence)accessLog.getUrl())) {
                    String url = "/" + appName + request.getRequestURI();
                    accessLog.setUrl(url);
                }
                if (StringUtils.isEmpty((CharSequence)accessLog.getChannel())) {
                    accessLog.setChannel(request.getHeader("AppType"));
                }
                token = request.getHeader("Authorization");
            }
            if (StringUtils.isEmpty((CharSequence)accessLog.getLogBy())) {
                UserInfo userInfo = UserUtils.getLoggedInUser();
                if (userInfo != null) {
                    accessLog.setLogBy(userInfo.getFullName());
                    accessLog.setLogById(Objects.toString(userInfo.getId(), ""));
                } else {
                    accessLog.setLogById("service:" + appName);
                    accessLog.setLogBy(appName);
                }
            }
            if (accessLog.getSuccess() == null) {
                accessLog.setSuccess(Boolean.valueOf(true));
            }
            if (accessLog.getStatus() == null) {
                accessLog.setStatus(Integer.valueOf(Boolean.TRUE.equals(accessLog.getSuccess()) ? 200 : 400));
            }
            AccessLogEvent event = new AccessLogEvent();
            event.setData((Object)accessLog);
            if (StringUtils.isNotBlank(token)) {
                event.setMetaData("Authorization", token);
            }
            try {
                LogUtils.logUtils.threadPoolTaskExecutor.execute(() -> LogUtils.logUtils.frameworkEventService.pushEvent((FrameworkEvent)event));
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block15;
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void logDataChange(DataChangeLog dataChangeLog) {
        if (LogUtils.logUtils.commonsBaseProperties != null && LogUtils.logUtils.commonsBaseProperties.getLogEnable().booleanValue()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Log data change of table [{}], data id [{}], long data id [{}], sql type [{}]", new Object[]{dataChangeLog.getTableName(), dataChangeLog.getDataId(), dataChangeLog.getLongDataId(), dataChangeLog.getSqlType()});
            }
            DataChangeLogEvent dataChangeLogEvent = new DataChangeLogEvent();
            dataChangeLogEvent.setData(dataChangeLog);
            LogUtils.logUtils.frameworkEventService.pushEvent((FrameworkEvent)dataChangeLogEvent);
        }
    }
}

