/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util.encrypt;

import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import com.cyberway.msf.commons.base.util.encrypt.StringEncryptor;
import org.apache.commons.lang3.StringUtils;
import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.encryption.pbe.config.SimpleStringPBEConfig;
import org.jasypt.salt.SaltGenerator;
import org.jasypt.salt.StringFixedSaltGenerator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service(value="stringEncryptor")
@ConditionalOnProperty(prefix="commons.base.encryptor", name={"type"}, havingValue="PBE")
public class JasyptStringEncryptor
implements StringEncryptor {
    private static final String SALT_GENERATOR_CLASS = "org.jasypt.salt.StringFixedSaltGenerator";
    private final CommonsBaseProperties commonsBaseProperties;
    private PooledPBEStringEncryptor encryptor;

    public JasyptStringEncryptor(CommonsBaseProperties commonsBaseProperties) {
        this.commonsBaseProperties = commonsBaseProperties;
        this.initEncryptor();
    }

    protected void initEncryptor() {
        this.encryptor = new PooledPBEStringEncryptor();
        SimpleStringPBEConfig config = new SimpleStringPBEConfig();
        config.setPassword(this.commonsBaseProperties.getEncryptor().getPassword());
        config.setAlgorithm(this.commonsBaseProperties.getEncryptor().getAlgorithm());
        config.setKeyObtentionIterations(this.commonsBaseProperties.getEncryptor().getKeyObtentionIterations());
        config.setPoolSize(this.commonsBaseProperties.getEncryptor().getPoolSize());
        config.setStringOutputType(this.commonsBaseProperties.getEncryptor().getStringOutputType());
        if (StringUtils.equals((CharSequence)this.commonsBaseProperties.getEncryptor().getSaltGeneratorClassName(), (CharSequence)SALT_GENERATOR_CLASS)) {
            this.encryptor.setSaltGenerator((SaltGenerator)new StringFixedSaltGenerator(this.commonsBaseProperties.getEncryptor().getPassword()));
        } else {
            config.setSaltGeneratorClassName(this.commonsBaseProperties.getEncryptor().getSaltGeneratorClassName());
        }
        this.encryptor.setConfig((PBEConfig)config);
    }

    @Override
    public String encrypt(String data) {
        return this.encryptor.encrypt(data);
    }

    @Override
    public String decrypt(String encryptedData) {
        return this.encryptor.decrypt(encryptedData);
    }
}

