/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.aspect;

import com.cyberway.msf.commons.base.annotation.LogBaseRecord;
import com.cyberway.msf.commons.base.annotation.LogRecord;
import com.cyberway.msf.commons.base.controller.BaseController;
import com.cyberway.msf.commons.base.entity.log.LogRecordOps;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class LogRecordOperationSource {
    private static final Pattern MODULE_PATTERN = Pattern.compile("\\{\\{#_baseModule}}");
    private static final Pattern COLUMN_PATTERN = Pattern.compile("\\{\\{#_baseColumn}}");

    public Collection<LogRecordOps> computeLogRecordOperations(Method method, Class<?> targetClass) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, targetClass);
        specificMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod);
        return this.parseLogRecordAnnotations(method, specificMethod, targetClass);
    }

    private Collection<LogRecordOps> parseLogRecordAnnotations(Method method, AnnotatedElement ae, Class<?> targetClass) {
        LogRecord recordAnnotation = (LogRecord)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)ae, LogRecord.class);
        if (method.getDeclaringClass().isAssignableFrom(BaseController.class) && targetClass.getDeclaredAnnotation(LogBaseRecord.class) == null) {
            return null;
        }
        if (recordAnnotation != null) {
            return Collections.singletonList(this.parseLogRecordAnnotation(ae, recordAnnotation, targetClass));
        }
        return null;
    }

    private LogRecordOps parseLogRecordAnnotation(AnnotatedElement ae, LogRecord recordAnnotation, Class<?> targetClass) {
        LogBaseRecord logBaseRecord = targetClass.getAnnotation(LogBaseRecord.class);
        LogRecordOps logRecordOps = logBaseRecord != null ? this.buildBaseLogRecordOps(recordAnnotation, logBaseRecord) : this.buildDefaultLogRecordOps(recordAnnotation);
        this.validateLogRecordOperation(ae, logRecordOps);
        return logRecordOps;
    }

    private LogRecordOps buildDefaultLogRecordOps(LogRecord recordAnnotation) {
        return LogRecordOps.builder().successLogTemplate(recordAnnotation.success()).failLogTemplate(recordAnnotation.fail()).module(recordAnnotation.module()).bizNo(recordAnnotation.bizNo()).operatorId(recordAnnotation.operator()).extra(recordAnnotation.extra()).condition(recordAnnotation.condition()).build();
    }

    private LogRecordOps buildBaseLogRecordOps(LogRecord recordAnnotation, LogBaseRecord logBaseRecord) {
        return LogRecordOps.builder().successLogTemplate(this.handlePreSpEL(recordAnnotation.success(), logBaseRecord)).failLogTemplate(this.handlePreSpEL(recordAnnotation.fail(), logBaseRecord)).module(this.handlePreSpEL(recordAnnotation.module(), logBaseRecord)).bizNo(this.handlePreSpEL(recordAnnotation.bizNo(), logBaseRecord)).operatorId(this.handlePreSpEL(recordAnnotation.operator(), logBaseRecord)).extra(this.handlePreSpEL(recordAnnotation.extra(), logBaseRecord)).condition(this.handlePreSpEL(recordAnnotation.condition(), logBaseRecord)).build();
    }

    private void validateLogRecordOperation(AnnotatedElement ae, LogRecordOps recordOps) {
        if (!StringUtils.hasText((String)recordOps.getSuccessLogTemplate()) && !StringUtils.hasText((String)recordOps.getFailLogTemplate())) {
            throw new IllegalStateException("Invalid logRecord annotation configuration on '" + ae.toString() + "'. 'one of successTemplate and failLogTemplate' attribute must be set.");
        }
    }

    private String handlePreSpEL(String preSpElTemplate, LogBaseRecord logBaseRecord) {
        if (!StringUtils.hasText((String)preSpElTemplate)) {
            return preSpElTemplate;
        }
        Matcher matcher = MODULE_PATTERN.matcher(preSpElTemplate);
        while (matcher.find()) {
            preSpElTemplate = preSpElTemplate.replaceAll(MODULE_PATTERN.pattern(), logBaseRecord.module());
        }
        matcher = COLUMN_PATTERN.matcher(preSpElTemplate);
        while (matcher.find()) {
            preSpElTemplate = preSpElTemplate.replaceAll(COLUMN_PATTERN.pattern(), logBaseRecord.column());
        }
        return preSpElTemplate;
    }
}

