/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.configuration;

import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import com.cyberway.msf.commons.model.handler.EncryptTypeHandler;
import org.apache.commons.lang3.StringUtils;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.encryption.pbe.config.SimpleStringPBEConfig;
import org.jasypt.salt.SaltGenerator;
import org.jasypt.salt.StringFixedSaltGenerator;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(value={CommonsBaseProperties.class})
public class EncryptorConfig {
    private static final String SALT_GENERATOR_CLASS = "org.jasypt.salt.StringFixedSaltGenerator";
    private final CommonsBaseProperties commonsBaseProperties;

    public EncryptorConfig(CommonsBaseProperties commonsBaseProperties) {
        this.commonsBaseProperties = commonsBaseProperties;
    }

    @Primary
    @Bean(value={"jasyptStringEncryptor"})
    public StringEncryptor stringEncryptor() {
        PooledPBEStringEncryptor encryptor = new PooledPBEStringEncryptor();
        SimpleStringPBEConfig config = new SimpleStringPBEConfig();
        config.setPassword(this.commonsBaseProperties.getEncryptor().getPassword());
        config.setAlgorithm(this.commonsBaseProperties.getEncryptor().getAlgorithm());
        config.setKeyObtentionIterations(this.commonsBaseProperties.getEncryptor().getKeyObtentionIterations());
        config.setPoolSize(this.commonsBaseProperties.getEncryptor().getPoolSize());
        config.setStringOutputType(this.commonsBaseProperties.getEncryptor().getStringOutputType());
        if (StringUtils.equals((CharSequence)this.commonsBaseProperties.getEncryptor().getSaltGeneratorClassName(), (CharSequence)SALT_GENERATOR_CLASS)) {
            encryptor.setSaltGenerator((SaltGenerator)new StringFixedSaltGenerator(this.commonsBaseProperties.getEncryptor().getPassword()));
        } else {
            config.setSaltGeneratorClassName(this.commonsBaseProperties.getEncryptor().getSaltGeneratorClassName());
        }
        encryptor.setConfig((PBEConfig)config);
        return encryptor;
    }

    @Bean
    public EncryptTypeHandler.EncryptorAdapter encryptorAdapter(final StringEncryptor stringEncryptor) {
        return new EncryptTypeHandler.EncryptorAdapter(){

            public String encrypt(String message) {
                return Boolean.TRUE.equals(EncryptorConfig.this.commonsBaseProperties.getEncryptor().getEncryptHandlerEnable()) ? stringEncryptor.encrypt(message) : message;
            }

            public String decrypt(String encryptedMessage) {
                if (Boolean.TRUE.equals(EncryptorConfig.this.commonsBaseProperties.getEncryptor().getEncryptHandlerEnable())) {
                    try {
                        return stringEncryptor.decrypt(encryptedMessage);
                    }
                    catch (Exception ex) {
                        return encryptedMessage;
                    }
                }
                return encryptedMessage;
            }
        };
    }

    @Bean
    public EncryptTypeHandler encryptTypeHandler() {
        return new EncryptTypeHandler();
    }
}

