/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.configuration;

import com.cyberway.msf.commons.base.aspect.BeanFactoryLogRecordAdvisor;
import com.cyberway.msf.commons.base.aspect.LogFunctionParser;
import com.cyberway.msf.commons.base.aspect.LogRecordExpressionEvaluator;
import com.cyberway.msf.commons.base.aspect.LogRecordInterceptor;
import com.cyberway.msf.commons.base.aspect.LogRecordOperationSource;
import com.cyberway.msf.commons.base.aspect.LogRecordPointcut;
import com.cyberway.msf.commons.base.factory.ParseFunctionFactory;
import com.cyberway.msf.commons.base.service.DefaultFunctionServiceImpl;
import com.cyberway.msf.commons.base.service.DefaultLogRecordServiceImpl;
import com.cyberway.msf.commons.base.service.DefaultOperatorGetServiceImpl;
import com.cyberway.msf.commons.base.service.DefaultParseFunction;
import com.cyberway.msf.commons.base.service.IFunctionService;
import com.cyberway.msf.commons.base.service.ILogRecordService;
import com.cyberway.msf.commons.base.service.IOperatorGetService;
import com.cyberway.msf.commons.base.service.IParseFunction;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

public class LogRecordProxyAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LogRecordProxyAutoConfiguration.class);

    @Bean
    public LogRecordOperationSource logRecordOperationSource() {
        return new LogRecordOperationSource();
    }

    @Bean
    @ConditionalOnMissingBean(value={IFunctionService.class})
    public IFunctionService functionService(ParseFunctionFactory parseFunctionFactory) {
        return new DefaultFunctionServiceImpl(parseFunctionFactory);
    }

    @Bean
    public ParseFunctionFactory parseFunctionFactory(List<IParseFunction> parseFunctions) {
        return new ParseFunctionFactory(parseFunctions);
    }

    @Bean
    @ConditionalOnMissingBean(value={IParseFunction.class})
    public DefaultParseFunction parseFunction() {
        return new DefaultParseFunction();
    }

    @Bean
    public LogRecordExpressionEvaluator logRecordExpressionEvaluator() {
        return new LogRecordExpressionEvaluator();
    }

    @Bean
    public LogRecordPointcut logRecordPointcut() {
        return new LogRecordPointcut();
    }

    @Bean
    public LogFunctionParser logFunctionParser(IFunctionService functionService) {
        return new LogFunctionParser(functionService);
    }

    @Bean
    public BeanFactoryLogRecordAdvisor logRecordAdvisor(LogRecordOperationSource logRecordOperationSource, LogRecordInterceptor logRecordInterceptor) {
        BeanFactoryLogRecordAdvisor advisor = new BeanFactoryLogRecordAdvisor();
        advisor.setLogRecordOperationSource(logRecordOperationSource);
        advisor.setAdvice((Advice)logRecordInterceptor);
        return advisor;
    }

    @Bean
    public LogRecordInterceptor logRecordInterceptor(LogRecordExpressionEvaluator logRecordExpressionEvaluator, LogFunctionParser logFunctionParser, LogRecordOperationSource logRecordOperationSource, IOperatorGetService operatorGetService, ILogRecordService logRecordService) {
        return new LogRecordInterceptor(logRecordExpressionEvaluator, logFunctionParser, logRecordOperationSource, operatorGetService, logRecordService);
    }

    @Bean
    @ConditionalOnMissingBean(value={IOperatorGetService.class})
    public IOperatorGetService operatorGetService() {
        return new DefaultOperatorGetServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean(value={ILogRecordService.class})
    public ILogRecordService recordService() {
        return new DefaultLogRecordServiceImpl();
    }
}

