/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import com.cyberway.msf.commons.base.util.MqUtils;
import com.cyberway.msf.mq.model.FrameworkEvent;
import com.cyberway.msf.ms.model.message.MessageTypeEnum;
import com.cyberway.msf.ms.model.message.dto.MessageDto;
import com.cyberway.msf.ms.model.mq.event.MessageEvent;
import com.cyberway.msf.ms.support.MessageDtoBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class MsUtils
extends MqUtils {
    private static MsUtils msUtils;

    @Override
    @PostConstruct
    public void init() {
        msUtils = this;
    }

    public static void removeMessage(String messageId) {
        MessageDto message = new MessageDto();
        message.setMessageId(messageId);
        msUtils.remove(message);
    }

    public static void sendTemplateMessage(String templateCode, Map<String, Object> params, Long toUser, String toUserName) {
        MessageDto message = new MessageDto();
        message.setTemplateCode(templateCode);
        message.setParamsMap(params);
        message.setReceiverId(toUser);
        message.setReceiver(toUserName);
        msUtils.send(message);
    }

    public static void sendMessage(MessageDto messageDto) {
        msUtils.send(messageDto);
    }

    public static void sendSms(List<String> receiverPhones, String templateCode, Map<String, Object> params) {
        MessageDto message = new MessageDtoBuilder().withPersistent(Boolean.valueOf(false)).withReceiverPhones(receiverPhones).withTemplateCode(templateCode).withTemplateParams(params).withScopes(new Byte[]{MessageTypeEnum.SMS.getId()}).build();
        msUtils.send(message);
    }

    public static void sendApn(List<Long> userIds, String templateCode, Map<String, Object> params, String appType) {
        if (null == params) {
            params = new HashMap<String, Object>(16);
        }
        params.put("application", appType);
        MessageDto message = new MessageDtoBuilder().withPersistent(Boolean.valueOf(false)).withToUserIds(userIds).withTemplateCode(templateCode).withTemplateParams(params).withScopes(new Byte[]{MessageTypeEnum.APNS.getId()}).build();
        msUtils.send(message);
    }

    public static void sendMessage(Long senderId, List<Long> receiverIds, String templateCode, Map<String, Object> params) {
        MessageDto message = new MessageDtoBuilder().withPersistent(Boolean.valueOf(true)).withToUserIds(receiverIds).withTemplateCode(templateCode).withTemplateParams(params).withSenderId(senderId).withScopes(new Byte[]{MessageTypeEnum.MESSAGE.getId()}).build();
        msUtils.send(message);
    }

    private void send(MessageDto messageDto) {
        MessageEvent event = new MessageEvent();
        event.setData((Object)messageDto);
        event.setOpType(Integer.valueOf(1));
        MsUtils.sendMessage((FrameworkEvent)event);
    }

    private void remove(MessageDto messageDto) {
        MessageEvent event = new MessageEvent();
        event.setData((Object)messageDto);
        event.setOpType(Integer.valueOf(2));
        MsUtils.sendMessage((FrameworkEvent)event);
    }
}

