/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.factory;

import com.cyberway.msf.commons.base.service.IParseFunction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ParseFunctionFactory {
    private Map<String, IParseFunction> allFunctionMap;

    public ParseFunctionFactory(List<IParseFunction> parseFunctions) {
        if (CollectionUtils.isEmpty(parseFunctions)) {
            return;
        }
        this.allFunctionMap = new HashMap<String, IParseFunction>();
        for (IParseFunction parseFunction : parseFunctions) {
            if (StringUtils.isEmpty((Object)parseFunction.functionName())) continue;
            this.allFunctionMap.put(parseFunction.functionName(), parseFunction);
        }
    }

    public IParseFunction getFunction(String functionName) {
        return this.allFunctionMap.get(functionName);
    }

    public boolean isBeforeFunction(String functionName) {
        return this.allFunctionMap.get(functionName) != null && this.allFunctionMap.get(functionName).executeBefore();
    }
}

