/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.service;

import com.cyberway.msf.commons.base.entity.log.LogRecord;
import com.cyberway.msf.commons.base.service.ILogRecordService;
import com.cyberway.msf.commons.base.util.IpUtils;
import com.cyberway.msf.commons.base.util.LogUtils;
import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.log.model.DataChangeLog;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class DefaultLogRecordServiceImpl
implements ILogRecordService {
    private static final Logger log = LoggerFactory.getLogger(DefaultLogRecordServiceImpl.class);

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void record(LogRecord logRecord) {
        log.info("\u3010logRecord\u3011log={}", (Object)logRecord);
        UserInfo userInfo = UserUtils.getLoggedInUser();
        DataChangeLog dataChangeLog = new DataChangeLog();
        dataChangeLog.setChangeTime(logRecord.getCreateTime());
        dataChangeLog.setDescription(logRecord.getAction());
        dataChangeLog.setActionName(logRecord.getModule());
        dataChangeLog.setOperatorName(userInfo == null ? null : userInfo.getFullName());
        dataChangeLog.setTableName(logRecord.getOperator());
        dataChangeLog.setDataId(logRecord.getBizNo());
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            dataChangeLog.setRequestUrl(request.getServletPath());
            dataChangeLog.setClientIp(IpUtils.getRemoteAddr(request));
            dataChangeLog.setOperatorFullName(request.getRequestURL().toString());
        }
        LogUtils.logDataChange(dataChangeLog);
    }
}

