/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import com.alibaba.fastjson.JSONObject;
import com.cyberway.msf.commons.base.support.annotation.log.BusinessLogEvent;
import com.cyberway.msf.commons.base.support.annotation.log.DataChangeLogEvent;
import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import com.cyberway.msf.commons.base.util.IpUtils;
import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.log.model.BusinessLog;
import com.cyberway.msf.log.model.DataChangeLog;
import com.cyberway.msf.mq.model.FrameworkEvent;
import com.cyberway.msf.mq.service.FrameworkEventService;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class LogUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogUtils.class);
    private final FrameworkEventService frameworkEventService;
    private final CommonsBaseProperties commonsBaseProperties;
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private static LogUtils logUtils;

    public LogUtils(FrameworkEventService frameworkEventService, CommonsBaseProperties commonsBaseProperties) {
        this.frameworkEventService = frameworkEventService;
        this.commonsBaseProperties = commonsBaseProperties;
        this.threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        this.threadPoolTaskExecutor.afterPropertiesSet();
        logUtils = this;
    }

    public static void log(String content, String tag, String source) {
        if (logUtils == null || LogUtils.logUtils.commonsBaseProperties == null || !Boolean.TRUE.equals(LogUtils.logUtils.commonsBaseProperties.getLogEnable()) || LogUtils.logUtils.frameworkEventService == null) {
            return;
        }
        try {
            BusinessLog log = LogUtils.buildLogHandler(content, tag, source);
            BusinessLogEvent businessLogEvent = new BusinessLogEvent();
            businessLogEvent.setData(log);
            LogUtils.logUtils.threadPoolTaskExecutor.execute(() -> LogUtils.logUtils.frameworkEventService.pushEvent((FrameworkEvent)businessLogEvent));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private static BusinessLog buildLogHandler(String content, String tag, String source) {
        String fromIp = "";
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            fromIp = IpUtils.getRemoteAddr(request);
        }
        UserInfo userInfo = UserUtils.getLoggedInUser();
        BusinessLog log = new BusinessLog();
        log.setContent(content);
        log.setFromIp(fromIp);
        log.setCreateTime(new Date());
        log.setModule(tag);
        log.setLogSource(!StringUtils.isEmpty((Object)source) ? source : "DEFAULT");
        if (userInfo != null) {
            log.setCreateBy(userInfo.getFullName());
            log.setCreateById((Long)userInfo.getId());
            String infoJson = userInfo.getJson();
            if (!StringUtils.isEmpty((Object)infoJson)) {
                try {
                    JSONObject jsonObject = JSONObject.parseObject((String)infoJson);
                    String loginSource = jsonObject.getString("loginSource");
                    log.setLogSource(StringUtils.isEmpty((Object)loginSource) ? "DEFAULT" : loginSource);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return log;
    }

    public static void log(String content, String tag) {
        LogUtils.log(content, tag, true);
    }

    public static void log(String content, String tag, boolean asyncSend) {
        if (logUtils == null || LogUtils.logUtils.commonsBaseProperties == null || !Boolean.TRUE.equals(LogUtils.logUtils.commonsBaseProperties.getLogEnable()) || LogUtils.logUtils.frameworkEventService == null) {
            return;
        }
        try {
            BusinessLog log = LogUtils.buildLogHandler(content, tag, null);
            BusinessLogEvent businessLogEvent = new BusinessLogEvent();
            businessLogEvent.setData(log);
            if (asyncSend) {
                LogUtils.logUtils.threadPoolTaskExecutor.execute(() -> LogUtils.logUtils.frameworkEventService.pushEvent((FrameworkEvent)businessLogEvent));
            } else {
                LogUtils.logUtils.frameworkEventService.pushEvent((FrameworkEvent)businessLogEvent);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void logByUser(String content, String tag, UserInfo userInfo) {
        if (logUtils == null || LogUtils.logUtils.commonsBaseProperties == null || !Boolean.TRUE.equals(LogUtils.logUtils.commonsBaseProperties.getLogEnable()) || LogUtils.logUtils.frameworkEventService == null) {
            return;
        }
        try {
            String fromIp = "";
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (attributes != null) {
                HttpServletRequest request = attributes.getRequest();
                fromIp = IpUtils.getRemoteAddr(request);
            }
            if (userInfo != null) {
                userInfo = UserUtils.getLoggedInUser();
            }
            BusinessLog log = new BusinessLog();
            log.setContent(content);
            log.setFromIp(fromIp);
            log.setCreateTime(new Date());
            log.setModule(tag);
            log.setCreateBy(userInfo == null ? null : userInfo.getFullName());
            log.setCreateById(userInfo == null ? null : (Long)userInfo.getId());
            BusinessLogEvent businessLogEvent = new BusinessLogEvent();
            businessLogEvent.setData(log);
            LogUtils.logUtils.threadPoolTaskExecutor.execute(() -> LogUtils.logUtils.frameworkEventService.pushEvent((FrameworkEvent)businessLogEvent));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void logDataChange(DataChangeLog dataChangeLog) {
        try {
            if (LogUtils.logUtils.commonsBaseProperties != null && LogUtils.logUtils.commonsBaseProperties.getLogEnable().booleanValue()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Log data change of table [{}], data id [{}], long data id [{}], sql type [{}]", new Object[]{dataChangeLog.getTableName(), dataChangeLog.getDataId(), dataChangeLog.getLongDataId(), dataChangeLog.getSqlType()});
                }
                DataChangeLogEvent dataChangeLogEvent = new DataChangeLogEvent();
                dataChangeLogEvent.setData(dataChangeLog);
                LogUtils.logUtils.frameworkEventService.pushEvent((FrameworkEvent)dataChangeLogEvent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4fdd\u5b58\u53ef\u89c6\u5316\u65e5\u5fd7\u5f02\u5e38:" + e);
        }
    }
}

