/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.aspect;

import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.base.annotation.ApiLog;
import com.cyberway.msf.commons.base.util.IpUtils;
import com.cyberway.msf.commons.base.util.LogUtils;
import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.log.model.DataChangeLog;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class ApiLogHandle {
    public ApiLogHandle() {
        System.out.println("1111");
    }

    @Pointcut(value=" @annotation(com.cyberway.msf.commons.base.annotation.ApiLog)")
    public void log() {
    }

    @Before(value="log()")
    public void deoBefore(JoinPoint joinPoint) {
        System.out.println("deoBefore");
    }

    @After(value="log()")
    public void doAfter(JoinPoint joinPoint) {
        System.out.println("doAfter");
    }

    @AfterReturning(returning="result", pointcut="log()")
    public void doAfterReturning(Object result) {
        System.out.println("result" + result);
    }

    @Around(value="log()")
    public Object aroundLogging(ProceedingJoinPoint joinPoint) {
        System.out.println("\u6211\u662f\u73af\u7ed5\u901a\u77e5");
        Object obj = null;
        try {
            obj = joinPoint.proceed();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        UserInfo userInfo = UserUtils.getLoggedInUser();
        System.out.println("userInfo " + userInfo.getFullName());
        Object[] args = joinPoint.getArgs();
        String[] argNames = ((MethodSignature)joinPoint.getSignature()).getParameterNames();
        String methodName = joinPoint.getSignature().getName();
        System.out.println("\u53c2\u6570\u503c" + args);
        System.out.println("\u53c2\u6570\u540d" + argNames);
        String className = joinPoint.getSignature().getDeclaringType().getName();
        Class<?> clazz = null;
        try {
            Method[] allMethods;
            clazz = Class.forName(className);
            for (Method methodModel : allMethods = clazz.getDeclaredMethods()) {
                if (!methodModel.isAnnotationPresent(ApiLog.class) || !methodName.equals(methodModel.getName())) continue;
                ApiLog myAnnotation = methodModel.getAnnotation(ApiLog.class);
                DataChangeLog dataChangeLog = new DataChangeLog();
                ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                if (attributes != null) {
                    HttpServletRequest request = attributes.getRequest();
                    dataChangeLog.setRequestUrl(request.getServletPath());
                    dataChangeLog.setClientIp(IpUtils.getRemoteAddr(request));
                    dataChangeLog.setOperatorFullName(request.getRequestURL().toString());
                }
                dataChangeLog.setChangeTime(new Date());
                dataChangeLog.setActionName(myAnnotation.module());
                dataChangeLog.setOperatorId((Long)userInfo.getId());
                dataChangeLog.setOperatorName(userInfo.getFullName());
                dataChangeLog.setTableName(userInfo.getUsername());
                dataChangeLog.setDataId(null);
                dataChangeLog.setLongDataId(null);
                String description = null;
                System.out.println("logScope" + myAnnotation);
                if ("".equals(myAnnotation.entityTitle())) {
                    switch (methodName) {
                        case "searchNews": {
                            Object o = args[0];
                            Map objMap = BeanUtils.describe((Object)o);
                            System.out.println("111q: " + (String)objMap.get("newsType"));
                            if (((String)objMap.get("newsType")).equals("1")) {
                                description = userInfo.getFullName() + myAnnotation.action() + "[\u521b\u65b0\u8d44\u8baf\u5e73\u53f0]";
                                break;
                            }
                            description = userInfo.getFullName() + myAnnotation.action() + "[\u521b\u65b0\u4ea7\u54c1\u50a8\u5907\u5e93]";
                            break;
                        }
                        default: {
                            description = userInfo.getFullName() + myAnnotation.action();
                            break;
                        }
                    }
                } else {
                    ApiResponseResult apiResponseResult = (ApiResponseResult)obj;
                    Object object = apiResponseResult.getData();
                    Map objMap = BeanUtils.describe((Object)object);
                    String entityTitle = (String)objMap.get(myAnnotation.entityTitle());
                    description = userInfo.getFullName() + myAnnotation.action() + "[" + entityTitle + "]";
                }
                dataChangeLog.setDescription(description);
                LogUtils.logDataChange(dataChangeLog);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }
}

