/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.aspect;

import com.cyberway.msf.commons.base.aspect.LogFunctionParser;
import com.cyberway.msf.commons.base.aspect.LogRecordExpressionEvaluator;
import com.cyberway.msf.commons.base.aspect.LogRecordOperationSource;
import com.cyberway.msf.commons.base.context.LogRecordContext;
import com.cyberway.msf.commons.base.entity.log.LogRecord;
import com.cyberway.msf.commons.base.entity.log.LogRecordOps;
import com.cyberway.msf.commons.base.service.ILogRecordService;
import com.cyberway.msf.commons.base.service.IOperatorGetService;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.expression.EvaluationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class LogRecordInterceptor
implements MethodInterceptor,
BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(LogRecordInterceptor.class);
    private final LogRecordExpressionEvaluator expressionEvaluator;
    private final LogRecordOperationSource logRecordOperationSource;
    private final LogFunctionParser logFunctionParser;
    private final IOperatorGetService operatorGetService;
    private final ILogRecordService logRecordService;
    private BeanFactory beanFactory;
    private static final Pattern pattern = Pattern.compile("\\{\\s*(\\w*)\\s*\\{(.*?)}}");

    public LogRecordInterceptor(LogRecordExpressionEvaluator expressionEvaluator, LogFunctionParser logFunctionParser, LogRecordOperationSource logRecordOperationSource, IOperatorGetService operatorGetService, ILogRecordService logRecordService) {
        this.expressionEvaluator = expressionEvaluator;
        this.logRecordOperationSource = logRecordOperationSource;
        this.logFunctionParser = logFunctionParser;
        this.operatorGetService = operatorGetService;
        this.logRecordService = logRecordService;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        return this.execute(invocation, invocation.getThis(), invocation.getMethod(), invocation.getArguments());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execute(MethodInvocation invoker, Object target, Method method, Object[] args) throws Throwable {
        Class<?> targetClass = this.getTargetClass(target);
        Object ret = null;
        MethodExecuteResult methodExecuteResult = new MethodExecuteResult(true, null, "");
        LogRecordContext.putEmptySpan();
        ArrayList<LogRecordOps> operations = new ArrayList();
        HashMap<String, String> functionNameAndReturnMap = new HashMap();
        try {
            operations = this.logRecordOperationSource.computeLogRecordOperations(method, targetClass);
            List<String> spElTemplates = this.getBeforeExecuteFunctionTemplate(operations, targetClass);
            functionNameAndReturnMap = this.processBeforeExecuteFunctionTemplate(spElTemplates, targetClass, method, args);
        }
        catch (Exception e) {
            log.error("log record parse before function exception", (Throwable)e);
        }
        try {
            ret = invoker.proceed();
        }
        catch (Exception e) {
            methodExecuteResult = new MethodExecuteResult(false, e, e.getMessage());
        }
        try {
            if (!CollectionUtils.isEmpty(operations)) {
                this.recordExecute(ret, method, args, operations, targetClass, methodExecuteResult.isSuccess(), methodExecuteResult.getErrorMsg(), functionNameAndReturnMap);
            }
        }
        catch (Exception t) {
            log.error("log record parse exception", (Throwable)t);
        }
        finally {
            LogRecordContext.clear();
        }
        if (methodExecuteResult.throwable != null) {
            throw methodExecuteResult.throwable;
        }
        return ret;
    }

    public Map<String, String> processBeforeExecuteFunctionTemplate(Collection<String> templates, Class<?> targetClass, Method method, Object[] args) {
        HashMap<String, String> functionNameAndReturnValueMap = new HashMap<String, String>();
        EvaluationContext evaluationContext = this.expressionEvaluator.createEvaluationContext(method, args, targetClass, null, null, this.beanFactory);
        for (String expressionTemplate : templates) {
            if (!expressionTemplate.contains("{")) continue;
            Matcher matcher = pattern.matcher(expressionTemplate);
            while (matcher.find()) {
                String expression = matcher.group(2);
                if (expression.contains("#_ret") || expression.contains("#_errorMsg") || expression.contains("#_rvt")) continue;
                AnnotatedElementKey annotatedElementKey = new AnnotatedElementKey((AnnotatedElement)method, targetClass);
                String functionName = matcher.group(1);
                if (!this.logFunctionParser.isBeforeFunction(functionName)) continue;
                String value = this.expressionEvaluator.parseExpression(expression, annotatedElementKey, evaluationContext);
                String functionReturnValue = this.logFunctionParser.getFunctionReturnValue(null, value, expression, functionName);
                String functionCallInstanceKey = this.logFunctionParser.getFunctionCallInstanceKey(functionName, expression);
                functionNameAndReturnValueMap.put(functionCallInstanceKey, functionReturnValue);
            }
        }
        return functionNameAndReturnValueMap;
    }

    private Class<?> getTargetClass(Object target) {
        return AopProxyUtils.ultimateTargetClass((Object)target);
    }

    private List<String> getBeforeExecuteFunctionTemplate(Collection<LogRecordOps> operations, Class<?> targetClass) {
        ArrayList<String> spElTemplates = new ArrayList<String>();
        for (LogRecordOps operation : operations) {
            List<String> templates = this.getSpElTemplates(operation, operation.getSuccessLogTemplate(), targetClass);
            if (CollectionUtils.isEmpty(templates)) continue;
            spElTemplates.addAll(templates);
        }
        return spElTemplates;
    }

    private List<String> getSpElTemplates(LogRecordOps operation, String action, Class<?> targetClass) {
        ArrayList spElTemplates = Lists.newArrayList((Object[])new String[]{operation.getModule(), operation.getBizNo(), action, operation.getExtra()});
        if (!StringUtils.isEmpty((Object)operation.getCondition())) {
            spElTemplates.add(operation.getCondition());
        }
        return spElTemplates;
    }

    private void recordExecute(Object ret, Method method, Object[] args, Collection<LogRecordOps> operations, Class<?> targetClass, boolean success, String errorMsg, Map<String, String> functionNameAndReturnMap) {
        for (LogRecordOps operation : operations) {
            try {
                LogRecord logRecord;
                String action = this.getActionContent(success, operation);
                if (StringUtils.isEmpty((Object)action)) continue;
                List<String> spElTemplates = this.getSpElTemplates(operation, action, targetClass);
                String operatorIdFromService = this.getOperatorIdFromServiceAndPutTemplate(operation, spElTemplates);
                Map<String, String> expressionValues = this.processTemplate(spElTemplates, ret, targetClass, method, args, errorMsg, functionNameAndReturnMap);
                if (!this.logConditionPassed(operation.getCondition(), expressionValues) || StringUtils.isEmpty((Object)(logRecord = LogRecord.builder().module(expressionValues.get(operation.getModule())).bizNo(expressionValues.get(operation.getBizNo())).operator(this.getRealOperatorId(operation, operatorIdFromService, expressionValues)).extra(expressionValues.get(operation.getExtra())).action(expressionValues.get(action)).fail(!success).createTime(new Date()).build()).getAction())) continue;
                Preconditions.checkNotNull((Object)this.logRecordService, (Object)"bizLogService not init!!");
                this.logRecordService.record(logRecord);
            }
            catch (Exception t) {
                log.error("log record execute exception", (Throwable)t);
            }
        }
    }

    private String getOperatorIdFromServiceAndPutTemplate(LogRecordOps operation, List<String> spElTemplates) {
        String realOperatorId = "";
        if (StringUtils.isEmpty((Object)operation.getOperatorId())) {
            realOperatorId = this.operatorGetService.getUser().getOperatorId();
            if (StringUtils.isEmpty((Object)realOperatorId)) {
                throw new IllegalArgumentException("[LogRecord] operator is null");
            }
        } else {
            spElTemplates.add(operation.getOperatorId());
        }
        return realOperatorId;
    }

    public Map<String, String> processTemplate(Collection<String> templates, Object ret, Class<?> targetClass, Method method, Object[] args, String errorMsg, Map<String, String> beforeFunctionNameAndReturnMap) {
        HashMap<String, String> expressionValues = new HashMap<String, String>();
        EvaluationContext evaluationContext = this.expressionEvaluator.createEvaluationContext(method, args, targetClass, ret, errorMsg, this.beanFactory);
        for (String expressionTemplate : templates) {
            if (expressionTemplate.contains("{")) {
                Matcher matcher = pattern.matcher(expressionTemplate);
                StringBuffer parsedStr = new StringBuffer();
                AnnotatedElementKey annotatedElementKey = new AnnotatedElementKey((AnnotatedElement)method, targetClass);
                while (matcher.find()) {
                    String expression = matcher.group(2);
                    String functionName = matcher.group(1);
                    String value = this.expressionEvaluator.parseExpression(expression, annotatedElementKey, evaluationContext);
                    expression = this.logFunctionParser.getFunctionReturnValue(beforeFunctionNameAndReturnMap, value, expression, functionName);
                    matcher.appendReplacement(parsedStr, Matcher.quoteReplacement(Strings.nullToEmpty((String)expression)));
                }
                matcher.appendTail(parsedStr);
                expressionValues.put(expressionTemplate, parsedStr.toString());
                continue;
            }
            expressionValues.put(expressionTemplate, expressionTemplate);
        }
        return expressionValues;
    }

    private boolean logConditionPassed(String condition, Map<String, String> expressionValues) {
        return StringUtils.isEmpty((Object)condition) || StringUtils.endsWithIgnoreCase((String)expressionValues.get(condition), (String)"true");
    }

    private String getActionContent(boolean success, LogRecordOps operation) {
        return success ? operation.getSuccessLogTemplate() : operation.getFailLogTemplate();
    }

    private String getRealOperatorId(LogRecordOps operation, String operatorIdFromService, Map<String, String> expressionValues) {
        return !StringUtils.isEmpty((Object)operatorIdFromService) ? operatorIdFromService : expressionValues.get(operation.getOperatorId());
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    static class MethodExecuteResult {
        private boolean success;
        private Throwable throwable;
        private String errorMsg;

        public boolean isSuccess() {
            return this.success;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodExecuteResult)) {
                return false;
            }
            MethodExecuteResult other = (MethodExecuteResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            Throwable this$throwable = this.getThrowable();
            Throwable other$throwable = other.getThrowable();
            if (this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable)) {
                return false;
            }
            String this$errorMsg = this.getErrorMsg();
            String other$errorMsg = other.getErrorMsg();
            return !(this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MethodExecuteResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            Throwable $throwable = this.getThrowable();
            result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
            String $errorMsg = this.getErrorMsg();
            result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
            return result;
        }

        public String toString() {
            return "LogRecordInterceptor.MethodExecuteResult(success=" + this.isSuccess() + ", throwable=" + this.getThrowable() + ", errorMsg=" + this.getErrorMsg() + ")";
        }

        public MethodExecuteResult(boolean success, Throwable throwable, String errorMsg) {
            this.success = success;
            this.throwable = throwable;
            this.errorMsg = errorMsg;
        }

        public MethodExecuteResult() {
        }
    }
}

