/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.script.groovy;

import com.cyberway.msf.commons.base.support.script.groovy.ScriptEvaluator;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.CompiledScript;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.jsr223.GroovyCompiledScript;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class GroovyScriptEvaluator
implements ScriptEvaluator {
    private final Map<String, Class<? extends AbstractScript>> compiled = new ConcurrentHashMap<String, Class<? extends AbstractScript>>();
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private final GroovyClassLoader groovyClassLoader;

    public GroovyScriptEvaluator() {
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.setScriptBaseClass(AbstractScript.class.getName());
        this.groovyClassLoader = new GroovyClassLoader(this.classLoader, compilerConfiguration);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public CompiledScript compile(String source) {
        return new GroovyCompiledScript(new GroovyScriptEngineImpl(), this.compileInternal(source));
    }

    private Class<? extends AbstractScript> compileInternal(String source) {
        Assert.notNull((Object)source, (String)"source can't be null");
        return this.groovyClassLoader.parseClass(source);
    }

    @Override
    public Object evaluate(String source) {
        return this.evaluate(source, null);
    }

    @Override
    public Object evaluate(String source, Object root) {
        Assert.notNull((Object)source, (String)"source can't be null");
        Assert.isTrue((root == null || root instanceof Map || root instanceof Binding ? 1 : 0) != 0, (String)"root must be a Map or Binding");
        Class clazz = this.compiled.computeIfAbsent(source, this::compileInternal);
        Binding binding = new Binding();
        if (root != null) {
            binding = root instanceof Map ? new Binding((Map)root) : (Binding)root;
        }
        return InvokerHelper.createScript((Class)clazz, (Binding)binding).run();
    }

    public static abstract class AbstractScript
    extends Script {
        public AbstractScript() {
        }

        public AbstractScript(Binding binding) {
            super(binding);
        }

        public Object invokeMethod(String name, Object args) {
            try {
                return super.invokeMethod(name, args);
            }
            catch (MissingMethodException ex) {
                return this.getBinding().invokeMethod(name, args);
            }
        }

        public Object getProperty(String property) {
            try {
                return super.getProperty(property);
            }
            catch (MissingPropertyException ex) {
                return this.getBinding().getProperty(property);
            }
        }
    }
}

