/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.script.mvel;

import com.cyberway.msf.commons.base.support.script.mvel.Model;
import com.cyberway.msf.commons.base.support.script.mvel.ModelImpl;
import com.cyberway.msf.commons.base.support.script.mvel.ModelUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.mvel2.MVEL;

public class MvelModel<T>
implements Model<T> {
    public static final String ROOT_VAR = "root";
    private static final ConcurrentHashMap<String, Serializable> COMPILED_GET = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Serializable> COMPILED_SET = new ConcurrentHashMap();
    private final Object root;
    private final String expression;
    private final Map<String, Object> variables = new HashMap<String, Object>();
    private Model<T> defaultValue;

    public MvelModel(String expression) {
        this(null, expression);
    }

    public MvelModel(Object root, String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            throw new IllegalArgumentException("Expression is blank");
        }
        this.root = root;
        this.expression = expression;
    }

    public Object getRoot() {
        return this.root instanceof Model ? ModelUtils.getObject((Model)this.root) : this.root;
    }

    public String getExpression() {
        return this.expression;
    }

    protected Serializable getCompiledGetExpression() {
        return COMPILED_GET.computeIfAbsent(this.getExpression(), MVEL::compileExpression);
    }

    protected Serializable getCompiledSetExpression() {
        return COMPILED_SET.computeIfAbsent(this.getExpression(), MVEL::compileSetExpression);
    }

    public MvelModel<T> withDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue instanceof Model ? (ModelImpl<Object>)defaultValue : ModelImpl.of(defaultValue);
        return this;
    }

    public MvelModel<T> addVariable(String name, Object value) {
        this.variables.put(name, value);
        return this;
    }

    @Override
    public T getObject() {
        Object result = null;
        Serializable compiled = this.getCompiledGetExpression();
        result = compiled != null ? MVEL.executeExpression((Object)compiled, (Object)this.getRoot(), this.newVariableMap()) : MVEL.eval((String)this.getExpression(), (Object)this.getRoot(), this.newVariableMap());
        if (result == null) {
            result = ModelUtils.getObject(this.defaultValue);
        }
        return (T)result;
    }

    @Override
    public void setObject(T value) {
        MVEL.executeSetExpression((Serializable)this.getCompiledSetExpression(), (Object)this.getRoot(), value);
    }

    protected Map<String, Object> newVariableMap() {
        HashMap<String, Object> ctx = new HashMap<String, Object>(16);
        for (Map.Entry<String, Object> pair : this.variables.entrySet()) {
            String name = pair.getKey();
            Object value = pair.getValue() instanceof Model ? ModelUtils.getObject((Model)pair.getValue()) : pair.getValue();
            ctx.put(name, value);
        }
        ctx.put(ROOT_VAR, this.getRoot());
        return ctx;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(ROOT_VAR, this.getRoot()).append("expression", (Object)this.getExpression()).build();
    }
}

