/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util.tcbj;

import com.alibaba.fastjson.JSON;
import com.cyberway.msf.commons.base.entity.WordCatalog.WordCatalog;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlTools {
    private static final Logger logger = LoggerFactory.getLogger(XmlTools.class);
    private static final String regEx_html = "<[^>]+>";
    private static final String regEx_space = "\\s*|\t|\r|\n";

    public static String proccessWord(String html, List<WordCatalog> parents) {
        int seq = 1;
        HashMap<String, WordCatalog> parentMap = new HashMap<String, WordCatalog>();
        String[] array = html.replaceAll("\\<H", "<h").split("\\<h");
        StringBuilder body = new StringBuilder();
        for (String h : array) {
            if (h.trim().length() == 0) continue;
            char c = h.charAt(0);
            if (ArrayUtils.contains((char[])new char[]{'1', '2', '3', '4', '5'}, (char)c)) {
                h = "<h" + h;
                WordCatalog catalog = new WordCatalog("go" + seq++, XmlTools.getText(h));
                if (c == '1') {
                    parents.add(catalog);
                    parentMap.clear();
                    parentMap.put("1", catalog);
                } else {
                    String key = String.valueOf(c);
                    int current = Integer.valueOf(key);
                    parentMap.put(key, catalog);
                    WordCatalog parent = (WordCatalog)parentMap.get(current - 1 + "");
                    if (parent.getChildren() == null) {
                        parent.setChildren(new LinkedList<WordCatalog>());
                    }
                    parent.getChildren().add(catalog);
                }
                int idIndex = h.indexOf("id=");
                if (idIndex > 0) {
                    int end = h.indexOf(" ", idIndex + 4);
                    body.append("\n").append(h.substring(0, idIndex)).append(" id=\"").append(catalog.getId()).append("\" ").append(h.substring(end));
                    continue;
                }
                body.append("\n").append(h.substring(0, 3)).append(" id=\"").append(catalog.getId()).append("\" ").append(h.substring(3));
                continue;
            }
            body.append(h);
        }
        logger.info("body2:" + body);
        logger.info("catalog:" + JSON.toJSONString(parents));
        return body.toString();
    }

    private static String getText(String htag) {
        System.out.println("htext:" + htag);
        int index0 = htag.indexOf(">");
        int index1 = htag.indexOf("</h", index0);
        return XmlTools.delHTMLTag(htag.substring(index0 + 1, index1));
    }

    public static String delHTMLTag(String htmlStr) {
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll("");
        Pattern p_space = Pattern.compile(regEx_space, 2);
        Matcher m_space = p_space.matcher(htmlStr);
        htmlStr = m_space.replaceAll("");
        htmlStr = htmlStr.replaceAll("&nbsp;", "");
        return htmlStr.trim();
    }
}

