/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.cache;

import com.ctg.itrdc.cache.pool.CtgJedisPool;
import com.ctg.itrdc.cache.pool.CtgJedisPoolConfig;
import com.ctg.itrdc.cache.pool.CtgJedisPoolException;
import com.cyberway.msf.commons.cache.CtgRedisUtils;
import com.cyberway.msf.commons.cache.RedisProperties;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.HostAndPort;

@Configuration
@ConditionalOnProperty(value={"commons.redis.type"}, havingValue="ctg")
public class CtgRedisConfig {
    private final RedisProperties redisProperties;

    public CtgRedisConfig(RedisProperties redisProperties) {
        this.redisProperties = redisProperties;
    }

    private HostAndPort getRedisNode(String node) {
        String[] nodeObj = node.trim().split(":");
        if (nodeObj.length > 1) {
            String host = nodeObj[0];
            String port = nodeObj[1];
            return this.isNotEmpty(host) && this.isNotEmpty(port) ? new HostAndPort(host, Integer.valueOf(port).intValue()) : null;
        }
        return null;
    }

    private boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty((Object)str) && !StringUtils.isEmpty((Object)str.trim());
    }

    private List<HostAndPort> getNodeList(List<String> nodes) {
        ArrayList<HostAndPort> nodeList = new ArrayList<HostAndPort>();
        if (!CollectionUtils.isEmpty(nodes)) {
            for (String node : nodes) {
                HostAndPort redisNode;
                if (!this.isNotEmpty(node) || null == (redisNode = this.getRedisNode(node))) continue;
                nodeList.add(redisNode);
            }
            return nodeList;
        }
        return nodeList;
    }

    @Bean
    public CtgJedisPool ctgJedisPool() throws CtgJedisPoolException {
        List<HostAndPort> nodeList = this.getNodeList(this.redisProperties.getNodes());
        CtgJedisPoolConfig poolConfig = this.redisProperties.getCtg().clone();
        poolConfig.getNodes().addAll(nodeList);
        return new CtgJedisPool(poolConfig);
    }

    @Bean
    public CtgRedisUtils ctgRedisUtils(CtgJedisPool ctgJedisPool, Environment environment) {
        return new CtgRedisUtils(ctgJedisPool, environment);
    }
}

