/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.cache;

import com.ctg.itrdc.cache.pool.Constant;
import com.ctg.itrdc.cache.pool.CtgJedisPool;
import com.ctg.itrdc.cache.pool.ProxyJedis;
import com.cyberway.msf.commons.cache.CtgRedisException;
import com.cyberway.msf.commons.cache.RedisUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import redis.clients.jedis.exceptions.JedisDataException;

public class CtgRedisUtils
implements RedisUtils {
    private final CtgJedisPool ctgJedisPool;
    private final Environment environment;
    private final JdkSerializationRedisSerializer serializer;

    public CtgRedisUtils(CtgJedisPool ctgJedisPool, Environment environment) {
        this.ctgJedisPool = ctgJedisPool;
        this.environment = environment;
        this.serializer = new JdkSerializationRedisSerializer();
    }

    @Override
    public void setOrigin(String key, Object value) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            jedis.set(this.getByteOriginKey(key), this.serializer.serialize(value));
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    @Override
    public void setOrigin(String key, Object value, long time) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            jedis.setex(this.getByteOriginKey(key), (int)time, this.serializer.serialize(value));
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    @Override
    public Boolean setIfAbsentOrigin(String key, Object value) {
        Boolean bl;
        block8: {
            ProxyJedis jedis = this.ctgJedisPool.getResource();
            try {
                Long result = jedis.setnx(this.getByteOriginKey(key), this.serializer.serialize(value));
                bl = result != null && result > 0L;
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CtgRedisException(e);
                }
            }
            jedis.close();
        }
        return bl;
    }

    @Override
    public Boolean setIfAbsentOrigin(String key, Object value, long time) {
        Boolean bl;
        block9: {
            ProxyJedis jedis = this.ctgJedisPool.getResource();
            try {
                boolean success;
                byte[] byteKey = this.getByteOriginKey(key);
                Long result = jedis.setnx(byteKey, this.serializer.serialize(value));
                boolean bl2 = success = result != null && result > 0L;
                if (success) {
                    jedis.expire(byteKey, (int)time);
                }
                bl = success;
                if (jedis == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CtgRedisException(e);
                }
            }
            jedis.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean setIfPresentOrigin(String key, Object value) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            byte[] byteKey = this.getByteOriginKey(key);
            if (Boolean.TRUE.equals(jedis.exists(byteKey))) {
                jedis.set(this.getKey(key).getBytes(StandardCharsets.UTF_8), this.serializer.serialize(value));
                Boolean bl2 = true;
                return bl2;
            }
            Boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean setIfPresentOrigin(String key, Object value, long time) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            byte[] byteKey = this.getByteOriginKey(key);
            if (Boolean.TRUE.equals(jedis.exists(byteKey))) {
                jedis.setex(this.getKey(key).getBytes(StandardCharsets.UTF_8), (int)time, this.serializer.serialize(value));
                Boolean bl2 = true;
                return bl2;
            }
            Boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    @Override
    public Object getOrigin(String key) {
        Object object;
        block8: {
            ProxyJedis jedis = this.ctgJedisPool.getResource();
            try {
                object = this.serializer.deserialize(jedis.get(this.getByteOriginKey(key)));
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CtgRedisException(e);
                }
            }
            jedis.close();
        }
        return object;
    }

    @Override
    public Object getOrigin(String key, boolean allowLocalCache) {
        return this.getOrigin(key);
    }

    @Override
    public long generate(String key) {
        long l;
        block8: {
            ProxyJedis jedis = this.ctgJedisPool.getResource();
            try {
                l = jedis.incr(this.getByteOriginKey(this.getKey(key)));
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CtgRedisException(e);
                }
            }
            jedis.close();
        }
        return l;
    }

    @Override
    public long generate(String key, Date expireTime) {
        long l;
        block8: {
            ProxyJedis jedis = this.ctgJedisPool.getResource();
            try {
                byte[] byteOriginKey = this.getByteOriginKey(this.getKey(key));
                Long result = jedis.incr(byteOriginKey);
                jedis.expireAt(byteOriginKey, expireTime.getTime());
                l = result;
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CtgRedisException(e);
                }
            }
            jedis.close();
        }
        return l;
    }

    @Override
    public long generate(String key, int increment) {
        long l;
        block8: {
            ProxyJedis jedis = this.ctgJedisPool.getResource();
            try {
                l = jedis.incrBy(this.getByteOriginKey(this.getKey(key)), (long)increment);
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CtgRedisException(e);
                }
            }
            jedis.close();
        }
        return l;
    }

    @Override
    public long generate(String key, int increment, Date expireTime) {
        long l;
        block8: {
            ProxyJedis jedis = this.ctgJedisPool.getResource();
            try {
                byte[] byteOriginKey = this.getByteOriginKey(this.getKey(key));
                Long result = jedis.incrBy(byteOriginKey, (long)increment);
                jedis.expireAt(byteOriginKey, expireTime.getTime());
                l = result;
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CtgRedisException(e);
                }
            }
            jedis.close();
        }
        return l;
    }

    @Override
    public Long delOrigin(String ... key) {
        Long l;
        block8: {
            ProxyJedis jedis = this.ctgJedisPool.getResource();
            try {
                l = jedis.del((byte[][])Arrays.stream(key).map(this::getByteOriginKey).toArray(x$0 -> new byte[x$0][]));
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CtgRedisException(e);
                }
            }
            jedis.close();
        }
        return l;
    }

    @Override
    public void putHashOrigin(String key, Object hashKey, Object value) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            jedis.hset(this.getByteOriginKey(key), this.serializer.serialize(hashKey), this.serializer.serialize(value));
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    @Override
    public Object getHashOrigin(String key, Object hashKey) {
        return null;
    }

    @Override
    public void delHashOrigin(String key, Object ... hashKeys) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            jedis.hdel(this.getByteOriginKey(key), (byte[][])Arrays.stream(hashKeys).map(arg_0 -> ((JdkSerializationRedisSerializer)this.serializer).serialize(arg_0)).toArray(x$0 -> new byte[x$0][]));
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    @Override
    public Set<Object> hashKeysOrigin(String key) {
        Set<Object> set;
        block8: {
            ProxyJedis jedis = this.ctgJedisPool.getResource();
            try {
                set = jedis.hkeys(this.getByteOriginKey(key)).stream().map(arg_0 -> ((JdkSerializationRedisSerializer)this.serializer).deserialize(arg_0)).collect(Collectors.toSet());
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CtgRedisException(e);
                }
            }
            jedis.close();
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<Object, Object> entriesHashOrigin(String key) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            Map map = jedis.hgetAll(this.getByteOriginKey(key));
            if (map == null) {
                Map<Object, Object> map2 = Collections.emptyMap();
                return map2;
            }
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            for (Map.Entry entry : map.entrySet()) {
                result.put(this.serializer.deserialize((byte[])entry.getKey()), this.serializer.deserialize((byte[])entry.getValue()));
            }
            HashMap<Object, Object> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    @Override
    public Long listLeftPushOrigin(String key, Object value) {
        Long l;
        block8: {
            ProxyJedis jedis = this.ctgJedisPool.getResource();
            try {
                l = jedis.lpush(this.getByteOriginKey(key), (byte[][])new byte[][]{this.serializer.serialize(value)});
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CtgRedisException(e);
                }
            }
            jedis.close();
        }
        return l;
    }

    @Override
    public Long listRightPushOrigin(String key, Object value) {
        Long l;
        block8: {
            ProxyJedis jedis = this.ctgJedisPool.getResource();
            try {
                l = jedis.rpush(this.getByteOriginKey(key), (byte[][])new byte[][]{this.serializer.serialize(value)});
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CtgRedisException(e);
                }
            }
            jedis.close();
        }
        return l;
    }

    @Override
    public Object listLeftPopOrigin(String key) {
        Object object;
        block8: {
            ProxyJedis jedis = this.ctgJedisPool.getResource();
            try {
                object = this.serializer.deserialize(jedis.lpop(this.getByteOriginKey(key)));
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CtgRedisException(e);
                }
            }
            jedis.close();
        }
        return object;
    }

    @Override
    public Object listRightPopOrigin(String key) {
        Object object;
        block8: {
            ProxyJedis jedis = this.ctgJedisPool.getResource();
            try {
                object = this.serializer.deserialize(jedis.rpop(this.getByteOriginKey(key)));
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CtgRedisException(e);
                }
            }
            jedis.close();
        }
        return object;
    }

    @Override
    public Boolean expireOrigin(String key, long time) {
        Boolean bl;
        block8: {
            ProxyJedis jedis = this.ctgJedisPool.getResource();
            try {
                Long result = jedis.expire(this.getByteOriginKey(key), (int)time);
                bl = result != null && result > 0L;
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CtgRedisException(e);
                }
            }
            jedis.close();
        }
        return bl;
    }

    @Override
    public boolean lock(String key, long time) {
        return this.lockOrigin(this.generateLockKey(key), time);
    }

    @Override
    public void unlock(String key) {
        this.unlockOrigin(this.generateLockKey(key));
    }

    @Override
    public boolean lockOrigin(String key, long time) {
        boolean bl;
        block9: {
            ProxyJedis jedis = this.ctgJedisPool.getResource();
            try {
                jedis.lock(key, UUID.randomUUID().toString(), time * 1000L, 0L);
                bl = true;
                if (jedis == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JedisDataException e) {
                    return false;
                }
                catch (Exception e) {
                    throw new CtgRedisException(e);
                }
            }
            jedis.close();
        }
        return bl;
    }

    @Override
    public void unlockOrigin(String key) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            jedis.del(Constant.DEFAULT_LOCK_PRE + key);
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    @Override
    public Boolean hasKey(String key) {
        return this.hasKeyOrigin(this.getKey(key));
    }

    @Override
    public Boolean hasKeyOrigin(String key) {
        Boolean bl;
        block8: {
            ProxyJedis jedis = this.ctgJedisPool.getResource();
            try {
                bl = jedis.exists(this.getByteOriginKey(key));
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CtgRedisException(e);
                }
            }
            jedis.close();
        }
        return bl;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public RedisSerializer<?> getValueSerializer() {
        return this.serializer;
    }

    protected byte[] getByteOriginKey(String key) {
        return key.getBytes(StandardCharsets.UTF_8);
    }
}

