/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.cache;

import com.cyberway.msf.commons.cache.DefaultRedisUtils;
import com.cyberway.msf.commons.cache.RedisProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
@ConditionalOnProperty(value={"commons.redis.type"}, matchIfMissing=true, havingValue="default")
public class DefaultRedisConfig {
    @Autowired
    private RedisProperties redisProperties;

    @Bean
    RedisMessageListenerContainer container(RedisConnectionFactory connectionFactory) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        return container;
    }

    @Bean
    public RedisClusterConfiguration redisClusterConfiguration() {
        RedisClusterConfiguration redisClusterConfiguration = new RedisClusterConfiguration();
        if (CollectionUtils.isEmpty(this.redisProperties.getNodes())) {
            return redisClusterConfiguration;
        }
        List<String> nodes = this.redisProperties.getNodes();
        List<RedisNode> nodeList = this.getNodeList(nodes);
        redisClusterConfiguration.setClusterNodes(nodeList);
        if (this.redisProperties.getMaxRedirects() != null) {
            redisClusterConfiguration.setMaxRedirects(this.redisProperties.getMaxRedirects().intValue());
        }
        if (this.isNotEmpty(this.redisProperties.getPassword())) {
            redisClusterConfiguration.setPassword(this.redisProperties.getPassword());
        }
        return redisClusterConfiguration;
    }

    @Bean
    public RedisSentinelConfiguration redisSentinelConfiguration() {
        RedisSentinelConfiguration redisSentinelConfiguration = new RedisSentinelConfiguration();
        if (CollectionUtils.isEmpty(this.redisProperties.getNodes()) || StringUtils.isEmpty((Object)this.redisProperties.getSentinelMaster())) {
            return redisSentinelConfiguration;
        }
        List<String> nodes = this.redisProperties.getNodes();
        List<RedisNode> nodeList = this.getNodeList(nodes);
        redisSentinelConfiguration.master(this.redisProperties.getSentinelMaster());
        redisSentinelConfiguration.setSentinels(nodeList);
        if (this.isNotEmpty(this.redisProperties.getPassword())) {
            redisSentinelConfiguration.setPassword(this.redisProperties.getPassword());
        }
        if (this.redisProperties.getDatabase() != null) {
            redisSentinelConfiguration.setDatabase(this.redisProperties.getDatabase().intValue());
        }
        return redisSentinelConfiguration;
    }

    @Bean
    public RedisStandaloneConfiguration redisStandaloneConfiguration() {
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
        if (CollectionUtils.isEmpty(this.redisProperties.getNodes())) {
            return redisStandaloneConfiguration;
        }
        List<String> nodes = this.redisProperties.getNodes();
        String[] nodeObj = nodes.get(0).trim().split(":");
        if (nodeObj.length > 1) {
            String host = nodeObj[0];
            String port = nodeObj[1];
            if (this.isNotEmpty(host) && this.isNotEmpty(port)) {
                redisStandaloneConfiguration.setHostName(host);
                redisStandaloneConfiguration.setPort(Integer.valueOf(port).intValue());
            }
            if (this.isNotEmpty(this.redisProperties.getPassword())) {
                redisStandaloneConfiguration.setPassword(this.redisProperties.getPassword());
            }
            if (this.redisProperties.getDatabase() != null) {
                redisStandaloneConfiguration.setDatabase(this.redisProperties.getDatabase().intValue());
            }
        }
        return redisStandaloneConfiguration;
    }

    @Bean
    public JedisPoolConfig jedisPoolConfig() {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        if (null != this.redisProperties.getMaxTotal()) {
            jedisPoolConfig.setMaxTotal(this.redisProperties.getMaxTotal().intValue());
        }
        if (null != this.redisProperties.getMaxIdle()) {
            jedisPoolConfig.setMaxIdle(this.redisProperties.getMaxIdle().intValue());
        }
        if (null != this.redisProperties.getMinIdle()) {
            jedisPoolConfig.setMinIdle(this.redisProperties.getMinIdle().intValue());
        }
        if (null != this.redisProperties.getMaxWaitMillis()) {
            jedisPoolConfig.setMaxWaitMillis(this.redisProperties.getMaxWaitMillis().longValue());
        }
        if (null != this.redisProperties.getMinEvictableIdleTimeMillis()) {
            jedisPoolConfig.setMinEvictableIdleTimeMillis(this.redisProperties.getMinEvictableIdleTimeMillis().longValue());
        }
        if (null != this.redisProperties.getNumTestsPerEvictionRun()) {
            jedisPoolConfig.setNumTestsPerEvictionRun(this.redisProperties.getNumTestsPerEvictionRun().intValue());
        }
        if (null != this.redisProperties.getTimeBetweenEvictionRunsMillis()) {
            jedisPoolConfig.setTimeBetweenEvictionRunsMillis(this.redisProperties.getTimeBetweenEvictionRunsMillis().longValue());
        }
        if (null != this.redisProperties.getTestOnBorrow()) {
            jedisPoolConfig.setTestOnBorrow(this.redisProperties.getTestOnBorrow().booleanValue());
        }
        return jedisPoolConfig;
    }

    @Bean
    public JedisConnectionFactory jedisConnectionFactory(RedisClusterConfiguration redisClusterConfiguration, RedisSentinelConfiguration redisSentinelConfiguration, RedisStandaloneConfiguration redisStandaloneConfiguration, JedisPoolConfig jedisPoolConfig) {
        JedisClientConfiguration.JedisClientConfigurationBuilder clientConfigBuilder = JedisClientConfiguration.builder();
        if (null != this.redisProperties.getTimeout()) {
            clientConfigBuilder.readTimeout(Duration.ofMillis(this.redisProperties.getTimeout().intValue())).connectTimeout(Duration.ofMillis(this.redisProperties.getTimeout().intValue()));
        }
        clientConfigBuilder.usePooling().poolConfig((GenericObjectPoolConfig)jedisPoolConfig);
        if (Boolean.TRUE.equals(this.redisProperties.getUseSsl())) {
            clientConfigBuilder.useSsl();
        }
        JedisClientConfiguration clientConfig = clientConfigBuilder.build();
        JedisConnectionFactory jedisConnectionFactory = Boolean.TRUE.equals(this.redisProperties.getCluster()) ? new JedisConnectionFactory(redisClusterConfiguration, clientConfig) : (Boolean.TRUE.equals(this.redisProperties.getSentinel()) ? new JedisConnectionFactory(redisSentinelConfiguration, jedisPoolConfig) : new JedisConnectionFactory(redisStandaloneConfiguration, clientConfig));
        return jedisConnectionFactory;
    }

    @Bean
    public RedisTemplate redisTemplate(JedisConnectionFactory jedisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)jedisConnectionFactory);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        return redisTemplate;
    }

    @Bean
    public DefaultRedisUtils redisUtils(RedisMessageListenerContainer listenerContainer, RedisTemplate<String, Object> redisTemplate, Environment env) {
        return new DefaultRedisUtils(listenerContainer, redisTemplate, env, Boolean.TRUE.equals(this.redisProperties.getConfigEmptyKeyspace()));
    }

    private boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty((Object)str) && !StringUtils.isEmpty((Object)str.trim());
    }

    private List<RedisNode> getNodeList(List<String> nodes) {
        ArrayList<RedisNode> nodeList = new ArrayList<RedisNode>();
        if (!CollectionUtils.isEmpty(nodes)) {
            for (String node : nodes) {
                RedisNode redisNode;
                if (!this.isNotEmpty(node) || null == (redisNode = this.getRedisNode(node))) continue;
                nodeList.add(redisNode);
            }
            return nodeList;
        }
        return nodeList;
    }

    private RedisNode getRedisNode(String node) {
        String[] nodeObj = node.trim().split(":");
        if (nodeObj.length > 1) {
            String host = nodeObj[0];
            String port = nodeObj[1];
            return this.isNotEmpty(host) && this.isNotEmpty(port) ? new RedisNode(host, Integer.valueOf(port).intValue()) : null;
        }
        return null;
    }
}

