/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.cache;

import com.cyberway.msf.commons.cache.RedisUtils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.KeyspaceEventMessageListener;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;

public class DefaultRedisUtils
extends KeyspaceEventMessageListener
implements RedisUtils {
    private final RedisTemplate<String, Object> redisTemplate;
    private final Environment env;
    private static final Logger logger = LoggerFactory.getLogger(DefaultRedisUtils.class);
    private final Set<String> initializedKeys = new HashSet<String>();
    private final Cache<String, Object> localCache;
    private final Set<String> listeningTopic = new HashSet<String>();
    private final RedisMessageListenerContainer listenerContainer;

    public DefaultRedisUtils(RedisMessageListenerContainer listenerContainer, RedisTemplate<String, Object> redisTemplate, Environment env, boolean configEmptyKeyspace) {
        super(listenerContainer);
        if (configEmptyKeyspace) {
            this.setKeyspaceNotificationsConfigParameter(null);
        } else {
            this.setKeyspaceNotificationsConfigParameter("KA");
        }
        this.listenerContainer = listenerContainer;
        this.redisTemplate = redisTemplate;
        this.env = env;
        this.localCache = Caffeine.newBuilder().build();
    }

    @Override
    public Object getOrigin(String key) {
        return this.getOrigin(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getOrigin(String key, boolean allowLocalCache) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        if (allowLocalCache) {
            Object value = this.localCache.getIfPresent((Object)key);
            if (value == null && !this.initializedKeys.contains(key)) {
                value = this.redisTemplate.opsForValue().get((Object)key);
                Set<String> set = this.initializedKeys;
                synchronized (set) {
                    if (value != null) {
                        this.localCache.put((Object)key, value);
                    }
                    this.initializedKeys.add(key);
                }
                this.addListenKey(key);
            }
            return value;
        }
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public long generate(String key) {
        RedisAtomicLong counter = new RedisAtomicLong(this.getKey(key), this.redisTemplate.getConnectionFactory());
        return counter.incrementAndGet();
    }

    @Override
    public long generate(String key, Date expireTime) {
        RedisAtomicLong counter = new RedisAtomicLong(this.getKey(key), this.redisTemplate.getConnectionFactory());
        counter.expireAt(expireTime);
        return counter.incrementAndGet();
    }

    @Override
    public long generate(String key, int increment) {
        RedisAtomicLong counter = new RedisAtomicLong(this.getKey(key), this.redisTemplate.getConnectionFactory());
        return counter.addAndGet((long)increment);
    }

    @Override
    public long generate(String key, int increment, Date expireTime) {
        RedisAtomicLong counter = new RedisAtomicLong(this.getKey(key), this.redisTemplate.getConnectionFactory());
        counter.expireAt(expireTime);
        return counter.addAndGet((long)increment);
    }

    @Override
    public void setOrigin(String key, Object value) {
        if (null != key) {
            this.redisTemplate.opsForValue().set((Object)key, value);
        }
    }

    @Override
    public void setOrigin(String key, Object value, long time) {
        if (null != key) {
            this.setOrigin(key, value);
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
        }
    }

    @Override
    public Boolean setIfAbsentOrigin(String key, Object value) {
        if (null != key) {
            return this.redisTemplate.opsForValue().setIfAbsent((Object)key, value);
        }
        return false;
    }

    @Override
    public Boolean setIfAbsentOrigin(String key, Object value, long time) {
        if (null != key) {
            return this.redisTemplate.opsForValue().setIfAbsent((Object)key, value, time, TimeUnit.SECONDS);
        }
        return false;
    }

    @Override
    public Boolean setIfPresentOrigin(String key, Object value) {
        if (null != key) {
            return this.redisTemplate.opsForValue().setIfPresent((Object)key, value);
        }
        return false;
    }

    @Override
    public Boolean setIfPresentOrigin(String key, Object value, long time) {
        if (null != key) {
            return this.redisTemplate.opsForValue().setIfPresent((Object)key, value, time, TimeUnit.SECONDS);
        }
        return false;
    }

    @Override
    public Long delOrigin(String ... key) {
        if (key != null && key.length > 0) {
            ArrayList<String> delKeys = new ArrayList<String>();
            for (String k : key) {
                if (!StringUtils.isNotBlank((CharSequence)k)) continue;
                delKeys.add(k);
            }
            return this.redisTemplate.delete(delKeys);
        }
        return 0L;
    }

    @Override
    public void putHashOrigin(String key, Object hashKey, Object value) {
        if (null != key) {
            this.redisTemplate.opsForHash().put((Object)key, hashKey, value);
        }
    }

    @Override
    public Object getHashOrigin(String key, Object hashKey) {
        return null != key ? this.redisTemplate.opsForHash().get((Object)key, hashKey) : null;
    }

    @Override
    public void delHashOrigin(String key, Object ... hashKeys) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            this.redisTemplate.opsForHash().delete((Object)key, hashKeys);
        }
    }

    @Override
    public Set<Object> hashKeysOrigin(String key) {
        return null != key ? this.redisTemplate.opsForHash().keys((Object)key) : Collections.emptySet();
    }

    @Override
    public Map<Object, Object> entriesHashOrigin(String key) {
        return null != key ? this.redisTemplate.opsForHash().entries((Object)key) : Collections.emptyMap();
    }

    @Override
    public Long listLeftPushOrigin(String key, Object value) {
        return this.redisTemplate.opsForList().leftPush((Object)this.getKey(key), value);
    }

    @Override
    public Long listRightPushOrigin(String key, Object value) {
        return this.redisTemplate.opsForList().rightPush((Object)this.getKey(key), value);
    }

    @Override
    public Object listLeftPopOrigin(String key) {
        return this.redisTemplate.opsForList().leftPop((Object)this.getKey(key));
    }

    @Override
    public Object listRightPopOrigin(String key) {
        return this.redisTemplate.opsForList().rightPop((Object)this.getKey(key));
    }

    @Override
    public Boolean expireOrigin(String key, long time) {
        if (time > 0L) {
            return this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
        }
        return false;
    }

    @Override
    public boolean lock(String key, long time) {
        return this.lockOrigin(this.generateLockKey(key), time);
    }

    @Override
    public void unlock(String key) {
        this.unlockOrigin(this.generateLockKey(key));
    }

    @Override
    public boolean lockOrigin(String key, long time) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            return Boolean.TRUE.equals(this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)1, time, TimeUnit.SECONDS));
        }
        return false;
    }

    @Override
    public void unlockOrigin(String key) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            logger.debug("release RedisLock[{}].", (Object)key);
            this.redisTemplate.delete((Object)key);
        }
    }

    @Override
    public Boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)this.getKey(key));
    }

    @Override
    public Boolean hasKeyOrigin(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    @Override
    public Environment getEnvironment() {
        return this.env;
    }

    @Override
    public RedisSerializer<?> getValueSerializer() {
        return this.redisTemplate.getValueSerializer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHandleMessage(Message message) {
        String key = new String(message.getChannel(), StandardCharsets.UTF_8);
        int index = key.indexOf("__:");
        if (index > -1) {
            String operator = key.substring(11);
            key = key.substring(index + 3);
            Set<String> set = this.initializedKeys;
            synchronized (set) {
                this.initializedKeys.remove(key);
                this.localCache.invalidate((Object)key);
                if (operator.startsWith("del")) {
                    Set<String> set2 = this.listeningTopic;
                    synchronized (set2) {
                        this.listenerContainer.removeMessageListener((MessageListener)this, (Topic)new PatternTopic("__keyspace@*:" + key));
                        this.listeningTopic.remove(key);
                    }
                }
            }
        }
    }

    protected void doRegister(RedisMessageListenerContainer container) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addListenKey(String key) {
        if (!this.listeningTopic.contains(key)) {
            Set<String> set = this.listeningTopic;
            synchronized (set) {
                if (!this.listeningTopic.contains(key)) {
                    PatternTopic topic = new PatternTopic("__keyspace@*:" + key);
                    this.listenerContainer.addMessageListener((MessageListener)this, (Topic)topic);
                    this.listeningTopic.add(key);
                }
            }
        }
    }
}

