/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.cache;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.serializer.RedisSerializer;

public interface RedisUtils {
    default public void set(String key, Object value) {
        this.setOrigin(this.getKey(key), value);
    }

    default public void set(String key, Object value, long time) {
        this.setOrigin(this.getKey(key), value, time);
    }

    default public Boolean setIfAbsent(String key, Object value) {
        return this.setIfAbsentOrigin(this.getKey(key), value);
    }

    default public Boolean setIfAbsent(String key, Object value, long time) {
        return this.setIfAbsentOrigin(this.getKey(key), value, time);
    }

    default public Boolean setIfPresent(String key, Object value) {
        return this.setIfPresentOrigin(this.getKey(key), value);
    }

    default public Boolean setIfPresent(String key, Object value, long time) {
        return this.setIfPresentOrigin(this.getKey(key), value, time);
    }

    default public Object get(String key) {
        return this.get(key, false);
    }

    default public Object get(String key, boolean allowLocalCache) {
        return this.getOrigin(this.getKey(key), allowLocalCache);
    }

    public Object getOrigin(String var1);

    public Object getOrigin(String var1, boolean var2);

    default public Long del(String ... key) {
        if (key == null || key.length < 1) {
            return 0L;
        }
        return this.delOrigin((String[])Arrays.stream(key).map(this::getKey).toArray(String[]::new));
    }

    default public void putHash(String key, Object hashKey, Object value) {
        this.putHashOrigin(this.getKey(key), hashKey, value);
    }

    default public Object getHash(String key, Object hashKey) {
        return this.getHashOrigin(this.getKey(key), hashKey);
    }

    default public Map<Object, Object> entriesHash(String key) {
        return this.entriesHashOrigin(this.getKey(key));
    }

    default public void delHash(String key, Object ... hashKeys) {
        this.delHashOrigin(this.getKey(key), hashKeys);
    }

    default public Set<Object> hashKeys(String key) {
        return this.hashKeysOrigin(this.getKey(key));
    }

    default public Long listLeftPush(String key, Object value) {
        return this.listLeftPushOrigin(this.getKey(key), value);
    }

    default public Long listRightPush(String key, Object value) {
        return this.listRightPushOrigin(this.getKey(key), value);
    }

    default public Object listLeftPop(String key) {
        return this.listLeftPopOrigin(this.getKey(key));
    }

    default public Object listRightPop(String key) {
        return this.listRightPopOrigin(this.getKey(key));
    }

    default public Boolean expire(String key, long time) {
        return this.expireOrigin(this.getKey(key), time);
    }

    public long generate(String var1);

    public long generate(String var1, Date var2);

    public long generate(String var1, int var2);

    public long generate(String var1, int var2, Date var3);

    public void setOrigin(String var1, Object var2);

    public void setOrigin(String var1, Object var2, long var3);

    public Boolean setIfAbsentOrigin(String var1, Object var2);

    public Boolean setIfAbsentOrigin(String var1, Object var2, long var3);

    public Boolean setIfPresentOrigin(String var1, Object var2);

    public Boolean setIfPresentOrigin(String var1, Object var2, long var3);

    public Long delOrigin(String ... var1);

    public void putHashOrigin(String var1, Object var2, Object var3);

    public Object getHashOrigin(String var1, Object var2);

    public void delHashOrigin(String var1, Object ... var2);

    public Set<Object> hashKeysOrigin(String var1);

    public Map<Object, Object> entriesHashOrigin(String var1);

    public Long listLeftPushOrigin(String var1, Object var2);

    public Long listRightPushOrigin(String var1, Object var2);

    public Object listLeftPopOrigin(String var1);

    public Object listRightPopOrigin(String var1);

    public Boolean expireOrigin(String var1, long var2);

    public boolean lock(String var1, long var2);

    public void unlock(String var1);

    public boolean lockOrigin(String var1, long var2);

    public void unlockOrigin(String var1);

    public Boolean hasKey(String var1);

    public Boolean hasKeyOrigin(String var1);

    public Environment getEnvironment();

    public RedisSerializer<?> getValueSerializer();

    default public StringBuilder getPreKey() {
        StringBuilder buffer = new StringBuilder();
        String appName = this.getEnvironment().getProperty("spring.application.name");
        if (StringUtils.isNotBlank((CharSequence)appName)) {
            buffer.append(appName).append(":");
        }
        return buffer;
    }

    default public String getKey(String key) {
        return StringUtils.isNotBlank((CharSequence)key) ? this.getPreKey().append(key).toString() : key;
    }

    default public String generateLockKey(String key) {
        return String.format("LOCK:%s", this.getKey(key));
    }

    default public boolean lock(String key) {
        return this.lock(key, 30L);
    }

    default public boolean lockBusiness(String key, long time) {
        String lockKey = this.generateLockKey(key);
        if (this.lockOrigin(lockKey, time)) {
            this.set(lockKey, DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            return true;
        }
        return false;
    }

    default public boolean isvalidLockBusiness(String key, long time) {
        String lockKey = this.generateLockKey(key);
        Object value = this.get(lockKey);
        if (null != value && !"".equals(value)) {
            try {
                long times = (new Date().getTime() - DateUtils.parseDate((String)value.toString(), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}).getTime()) / 1000L;
                if (times < time) {
                    return true;
                }
            }
            catch (ParseException e) {
                return false;
            }
        }
        return false;
    }

    default public void unlockBusiness(String key) {
        String lockKey = this.generateLockKey(key);
        this.unlockOrigin(lockKey);
        this.del(lockKey);
    }
}

