/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.core.support;

import com.cyberway.msf.commons.core.i18n.I18nUtils;
import com.cyberway.msf.commons.core.support.CommonsCoreProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

@Configuration
@EnableConfigurationProperties(value={CommonsCoreProperties.class})
public class CommonsCoreConfig {
    private final CommonsCoreProperties commonsCoreProperties;

    public CommonsCoreConfig(CommonsCoreProperties commonsCoreProperties) {
        this.commonsCoreProperties = commonsCoreProperties;
    }

    @Bean
    public I18nUtils i18nUtils(MessageSource messageSource) {
        return new I18nUtils(messageSource);
    }

    @Bean
    public MessageSource messageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setUseCodeAsDefaultMessage(true);
        messageSource.setDefaultEncoding("UTF-8");
        messageSource.setCacheSeconds(0);
        messageSource.addBasenames(new String[]{"classpath:messages/common"});
        messageSource.addBasenames(new String[]{"classpath:messages/exception"});
        if (null != this.commonsCoreProperties.getCore().getI18n().getBasenames() && this.commonsCoreProperties.getCore().getI18n().getBasenames().length > 0) {
            for (String basename : this.commonsCoreProperties.getCore().getI18n().getBasenames()) {
                if (!StringUtils.isNotBlank((CharSequence)basename)) continue;
                messageSource.addBasenames(new String[]{"classpath:" + basename});
            }
            return messageSource;
        }
        return messageSource;
    }
}

