/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.core.i18n;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.MessageSource;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class I18nUtils {
    private final MessageSource messageSource;

    public I18nUtils(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public String getMessage(String key) {
        return this.getMessage(key, null, null, new Object[0]);
    }

    public String getMessageWithArgs(String key, boolean handleArgs, Object ... args) {
        return this.getMessage(key, handleArgs, null, null, args);
    }

    public String getMessageWithDfaultMessage(String key, @NonNull String defaultMessage, Object ... args) {
        return this.getMessageWithDfaultMessage(key, true, defaultMessage, args);
    }

    public String getMessageWithDfaultMessage(String key, boolean handleArgs, @NonNull String defaultMessage, Object ... args) {
        return this.getMessage(key, handleArgs, defaultMessage, null, args);
    }

    public String getMessageWithRequest(String key, @NonNull HttpServletRequest request, Object ... args) {
        return this.getMessageWithRequest(key, true, request, args);
    }

    public String getMessageWithRequest(String key, boolean handleArgs, @NonNull HttpServletRequest request, Object ... args) {
        return this.getMessage(key, handleArgs, null, request, args);
    }

    public String getMessage(String key, String defaultMessage, HttpServletRequest request, Object ... args) {
        return this.getMessage(key, true, defaultMessage, request, args);
    }

    public String getMessage(String key, boolean handleArgs, String defaultMessage, HttpServletRequest request, Object ... args) {
        Locale locale = null == request ? Locale.getDefault() : request.getLocale();
        return this.getMessageByLocale(key, handleArgs, defaultMessage, locale, args);
    }

    public String getMessageByLocale(String key, @NonNull Locale locale, Object ... args) {
        return this.getMessageByLocale(key, true, locale, args);
    }

    public String getMessageByLocale(String key, boolean handleArgs, @NonNull Locale locale, Object ... args) {
        return this.getMessageByLocale(key, handleArgs, null, locale, args);
    }

    public String getMessageByLocale(String key, String defaultMessage, @NonNull Locale locale, Object ... args) {
        return this.getMessageByLocale(key, true, defaultMessage, locale, args);
    }

    public String getMessageByLocale(String key, boolean handleArgs, String defaultMessage, @NonNull Locale locale, Object ... args) {
        if (handleArgs) {
            args = this.getArgsMessage(args, locale);
        }
        return null == defaultMessage ? this.messageSource.getMessage(key, args, locale) : this.messageSource.getMessage(key, args, defaultMessage, locale);
    }

    private Object[] getArgsMessage(Object[] args, Locale locale) {
        if (null != args && args.length > 0) {
            Object[] result = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                result[i] = arg instanceof String ? this.messageSource.getMessage((String)arg, null, (String)arg, locale) : args[i];
            }
            return result;
        }
        return args;
    }
}

