/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.core.support;

import com.cyberway.msf.commons.cache.RedisUtils;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;

public class RedisMessageSource
extends ReloadableResourceBundleMessageSource {
    private final RedisMessageListenerContainer redisMessageListenerContainer;
    private final RedisUtils redisUtils;
    private final ConcurrentMap<Locale, ReloadableResourceBundleMessageSource.PropertiesHolder> cachedRedisProperties = new ConcurrentHashMap<Locale, ReloadableResourceBundleMessageSource.PropertiesHolder>();

    public RedisMessageSource(RedisMessageListenerContainer redisMessageListenerContainer, RedisUtils redisUtils) {
        this.redisMessageListenerContainer = redisMessageListenerContainer;
        this.redisUtils = redisUtils;
        this.initRedisCache();
        this.initMessageListenerAdapter();
    }

    private void initMessageListenerAdapter() {
        if (this.redisMessageListenerContainer != null) {
            MessageListenerAdapter messageListenerAdapter = new MessageListenerAdapter((Object)this, "refreshRedisCache");
            messageListenerAdapter.afterPropertiesSet();
            messageListenerAdapter.setSerializer(this.redisUtils.getValueSerializer());
            this.redisMessageListenerContainer.addMessageListener((MessageListener)messageListenerAdapter, (Topic)new ChannelTopic("refresh_message_source"));
        }
    }

    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        String property;
        ReloadableResourceBundleMessageSource.PropertiesHolder propertiesHolder = (ReloadableResourceBundleMessageSource.PropertiesHolder)this.cachedRedisProperties.get(locale);
        if (propertiesHolder != null && (property = propertiesHolder.getProperty(code)) != null) {
            return property;
        }
        return super.resolveCodeWithoutArguments(code, locale);
    }

    protected MessageFormat resolveCode(String code, Locale locale) {
        MessageFormat messageFormat;
        ReloadableResourceBundleMessageSource.PropertiesHolder propertiesHolder = (ReloadableResourceBundleMessageSource.PropertiesHolder)this.cachedRedisProperties.get(locale);
        if (propertiesHolder != null && (messageFormat = propertiesHolder.getMessageFormat(code, locale)) != null) {
            return messageFormat;
        }
        return super.resolveCode(code, locale);
    }

    public void refreshRedisCache(String languageTag) {
        Locale locale = Locale.forLanguageTag(languageTag);
        if (locale != null) {
            Object value = this.redisUtils.getHashOrigin("message_source_map", (Object)languageTag);
            if (value instanceof Map) {
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)((Map)value));
                ReloadableResourceBundleMessageSource.PropertiesHolder propertiesHolder = new ReloadableResourceBundleMessageSource.PropertiesHolder((ReloadableResourceBundleMessageSource)this, properties, -1L);
                this.cachedRedisProperties.put(locale, propertiesHolder);
            } else {
                this.cachedRedisProperties.remove(locale);
            }
        }
    }

    private void initRedisCache() {
        Map entries = this.redisUtils.entriesHashOrigin("message_source_map");
        for (Map.Entry entry : entries.entrySet()) {
            Object value;
            Locale locale = Locale.forLanguageTag(entry.getKey().toString());
            if (locale == null || !((value = entry.getValue()) instanceof Map)) continue;
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)((Map)value));
            ReloadableResourceBundleMessageSource.PropertiesHolder propertiesHolder = new ReloadableResourceBundleMessageSource.PropertiesHolder((ReloadableResourceBundleMessageSource)this, properties, -1L);
            this.cachedRedisProperties.put(locale, propertiesHolder);
        }
    }
}

