/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.lock.ctg;

import com.ctg.itrdc.cache.pool.CtgJedisPool;
import com.ctg.itrdc.cache.pool.ProxyJedis;
import com.cyberway.msf.commons.cache.CtgRedisException;
import com.cyberway.msf.commons.lock.LockFactory;
import com.cyberway.msf.commons.lock.ctg.CtgLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

public class CtgFactory
implements LockFactory {
    private final CtgJedisPool ctgJedisPool;

    public CtgFactory(CtgJedisPool ctgJedisPool) {
        this.ctgJedisPool = ctgJedisPool;
    }

    @Override
    public Lock lock(String lockKey) {
        CtgLock lock = new CtgLock(this.ctgJedisPool, lockKey);
        lock.lock();
        return lock;
    }

    @Override
    public Lock lock(String lockKey, long leaseTime) {
        CtgLock lock = new CtgLock(this.ctgJedisPool, lockKey, leaseTime);
        lock.lock();
        return lock;
    }

    @Override
    public Lock lock(String lockKey, TimeUnit unit, long leaseTime) {
        CtgLock lock = new CtgLock(this.ctgJedisPool, lockKey, unit.toMillis(leaseTime));
        lock.lock();
        return lock;
    }

    @Override
    public boolean tryLock(String lockKey, TimeUnit unit, long waitTime, long leaseTime) {
        CtgLock lock = new CtgLock(this.ctgJedisPool, lockKey, unit.toMillis(leaseTime));
        return lock.tryLock(waitTime, unit);
    }

    @Override
    public void unlock(String lockKey) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            jedis.del(lockKey);
        }
        catch (Exception e) {
            throw new CtgRedisException((Throwable)e);
        }
    }

    @Override
    public void unlock(Lock lock) {
        lock.unlock();
    }
}

