/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.lock.ctg;

import com.ctg.itrdc.cache.pool.CtgJedisPool;
import com.ctg.itrdc.cache.pool.ProxyJedis;
import com.cyberway.msf.commons.cache.CtgRedisException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.exceptions.JedisDataException;

public class CtgLock
implements Lock {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CtgJedisPool ctgJedisPool;
    private final String lockKey;
    private final String lockValue;
    private final Long leaseTime;

    public CtgLock(CtgJedisPool ctgJedisPool, String lockKey) {
        this(ctgJedisPool, lockKey, null);
    }

    public CtgLock(CtgJedisPool ctgJedisPool, String lockKey, Long leaseTime) {
        this.ctgJedisPool = ctgJedisPool;
        this.lockKey = lockKey;
        this.leaseTime = leaseTime == null ? 3600000L : leaseTime;
        this.lockValue = UUID.randomUUID().toString();
    }

    @Override
    public void lock() {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            jedis.lock(this.lockKey, this.lockValue, this.leaseTime.longValue());
        }
        catch (Exception e) {
            throw new CtgRedisException((Throwable)e);
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lock();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean tryLock() {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            jedis.lock(this.lockKey, this.lockValue, this.leaseTime.longValue(), 0L);
            boolean bl = true;
            return bl;
        }
        catch (JedisDataException e) {
            return false;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean tryLock(long time, @Nonnull TimeUnit unit) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            jedis.lock(this.lockKey, this.lockValue, this.leaseTime.longValue(), unit.toMillis(time));
            boolean bl = true;
            return bl;
        }
        catch (JedisDataException e) {
            return false;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void unlock() {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            jedis.unlock(this.lockKey, this.lockValue);
        }
        catch (Exception e) {
            throw new CtgRedisException((Throwable)e);
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }
}

