/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.lock.redisson;

import com.cyberway.msf.commons.cache.RedisProperties;
import com.cyberway.msf.commons.lock.redisson.RedissonFactory;
import com.cyberway.msf.commons.lock.redisson.RedissonProperties;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.ReadMode;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.config.SslProvider;
import org.redisson.config.SubscriptionMode;
import org.redisson.connection.balancer.LoadBalancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ResourceUtils;

@Configuration
@ConditionalOnProperty(value={"commons.lock.type"}, havingValue="REDISSON", matchIfMissing=true)
@EnableConfigurationProperties(value={RedissonProperties.class})
public class RedissonConfig {
    private final Logger logger = LoggerFactory.getLogger(RedissonConfig.class);
    @Autowired
    private RedissonProperties redissonProperties;
    @Autowired
    private RedisProperties redisProperties;

    private Config configJson() throws IOException {
        File file = ResourceUtils.getFile((String)this.redissonProperties.getConfigFile().getJson());
        return Config.fromJSON((File)file);
    }

    private Config config(Boolean cluster, Boolean sentinel) throws IOException {
        Config config = new Config();
        try {
            config.setThreads(this.redissonProperties.getThreads().intValue());
            config.setNettyThreads(this.redissonProperties.getNettyThreads().intValue());
            config.setCodec((Codec)Class.forName(this.redissonProperties.getCodec()).newInstance());
            if (cluster != null && cluster.booleanValue()) {
                List<Object> nodes = new ArrayList();
                if (CollectionUtils.isEmpty(this.redissonProperties.getClusterServersConfig().getNodeAddresses())) {
                    nodes = this.redisProperties.getNodes();
                }
                nodes = nodes.stream().map(node -> "redis://" + node).collect(Collectors.toList());
                ((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)config.useClusterServers().setIdleConnectionTimeout(this.redissonProperties.getClusterServersConfig().getIdleConnectionTimeout().intValue())).setPingConnectionInterval(this.redissonProperties.getClusterServersConfig().getPingTimeout().intValue())).setConnectTimeout(this.redissonProperties.getClusterServersConfig().getConnectTimeout().intValue())).setTimeout(this.redissonProperties.getClusterServersConfig().getTimeout().intValue())).setRetryAttempts(this.redissonProperties.getClusterServersConfig().getRetryAttempts().intValue())).setRetryInterval(this.redissonProperties.getClusterServersConfig().getRetryInterval().intValue())).setFailedSlaveReconnectionInterval(this.redissonProperties.getClusterServersConfig().getReconnectionTimeout().intValue())).setRetryAttempts(this.redissonProperties.getClusterServersConfig().getFailedAttempts().intValue())).setPassword(this.redisProperties.getPassword())).setSubscriptionsPerConnection(this.redissonProperties.getClusterServersConfig().getSubscriptionsPerConnection().intValue())).setClientName(this.redissonProperties.getClusterServersConfig().getClientName())).setLoadBalancer((LoadBalancer)Class.forName(this.redissonProperties.getClusterServersConfig().getLoadBalancer()).newInstance())).setSubscriptionConnectionMinimumIdleSize(this.redissonProperties.getClusterServersConfig().getSubscriptionConnectionMinimumIdleSize().intValue())).setSubscriptionConnectionPoolSize(this.redissonProperties.getClusterServersConfig().getSubscriptionConnectionPoolSize().intValue())).setSlaveConnectionMinimumIdleSize(this.redissonProperties.getClusterServersConfig().getSlaveConnectionMinimumIdleSize().intValue())).setSlaveConnectionPoolSize(this.redissonProperties.getClusterServersConfig().getSlaveConnectionPoolSize().intValue())).setMasterConnectionMinimumIdleSize(this.redissonProperties.getClusterServersConfig().getMasterConnectionMinimumIdleSize().intValue())).setMasterConnectionPoolSize(this.redissonProperties.getClusterServersConfig().getMasterConnectionPoolSize().intValue())).setReadMode(ReadMode.valueOf((String)this.redissonProperties.getClusterServersConfig().getReadMode()))).setScanInterval(this.redissonProperties.getClusterServersConfig().getScanInterval().intValue()).addNodeAddress(nodes.toArray(new String[0]));
            } else if (sentinel != null && sentinel.booleanValue()) {
                List<Object> nodes = new ArrayList();
                if (CollectionUtils.isEmpty(this.redissonProperties.getClusterServersConfig().getNodeAddresses())) {
                    nodes = this.redisProperties.getNodes();
                }
                nodes = nodes.stream().map(node -> "redis://" + node).collect(Collectors.toList());
                ((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)config.useSentinelServers().setMasterName(this.redisProperties.getSentinelMaster()).addSentinelAddress(nodes.toArray(new String[0])).setReadMode(ReadMode.valueOf((String)this.redissonProperties.getSentinelServersConfig().getReadMode()))).setSubscriptionMode(SubscriptionMode.valueOf((String)this.redissonProperties.getSentinelServersConfig().getSubscriptionMode()))).setLoadBalancer((LoadBalancer)Class.forName(this.redissonProperties.getSentinelServersConfig().getLoadBalancer()).newInstance())).setSubscriptionConnectionMinimumIdleSize(this.redissonProperties.getSentinelServersConfig().getSubscriptionConnectionMinimumIdleSize().intValue())).setSubscriptionConnectionPoolSize(this.redissonProperties.getSentinelServersConfig().getSubscriptionConnectionPoolSize().intValue())).setSlaveConnectionMinimumIdleSize(this.redissonProperties.getSentinelServersConfig().getSlaveConnectionMinimumIdleSize().intValue())).setSubscriptionConnectionPoolSize(this.redissonProperties.getSentinelServersConfig().getSubscriptionConnectionPoolSize().intValue())).setMasterConnectionMinimumIdleSize(this.redissonProperties.getSentinelServersConfig().getMasterConnectionMinimumIdleSize().intValue())).setMasterConnectionPoolSize(this.redissonProperties.getSentinelServersConfig().getMasterConnectionPoolSize().intValue())).setIdleConnectionTimeout(this.redissonProperties.getSentinelServersConfig().getIdleConnectionTimeout().intValue())).setConnectTimeout(this.redissonProperties.getSentinelServersConfig().getConnectTimeout().intValue())).setTimeout(this.redissonProperties.getSentinelServersConfig().getTimeout().intValue())).setRetryAttempts(this.redissonProperties.getSentinelServersConfig().getRetryAttempts().intValue())).setRetryInterval(this.redissonProperties.getSentinelServersConfig().getRetryInterval().intValue())).setFailedSlaveReconnectionInterval(this.redissonProperties.getSentinelServersConfig().getReconnectionTimeout().intValue())).setRetryAttempts(this.redissonProperties.getSentinelServersConfig().getFailedAttempts().intValue())).setDatabase(this.redissonProperties.getSentinelServersConfig().getDatabase().intValue()).setPassword(this.redisProperties.getPassword())).setSubscriptionsPerConnection(this.redissonProperties.getSentinelServersConfig().getSubscriptionsPerConnection().intValue())).setClientName(this.redissonProperties.getSentinelServersConfig().getClientName())).setSslEnableEndpointIdentification(this.redissonProperties.getSentinelServersConfig().getSslEnableEndpointIdentification().booleanValue())).setSslProvider(SslProvider.valueOf((String)this.redissonProperties.getSentinelServersConfig().getSslProvider()))).setSslTruststore(URI.create(this.redissonProperties.getSentinelServersConfig().getSslTruststore()).toURL())).setSslTruststorePassword(this.redissonProperties.getSentinelServersConfig().getSslTruststorePassword())).setSslKeystore(URI.create(this.redissonProperties.getSentinelServersConfig().getSslKeystore()).toURL())).setSslKeystorePassword(this.redissonProperties.getSentinelServersConfig().getSslKeystorePassword());
            } else {
                ((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setIdleConnectionTimeout(this.redissonProperties.getSingleServerConfig().getIdleConnectionTimeout().intValue())).setPingConnectionInterval(this.redissonProperties.getSingleServerConfig().getPingTimeout().intValue())).setConnectTimeout(this.redissonProperties.getSingleServerConfig().getConnectTimeout().intValue())).setTimeout(this.redissonProperties.getSingleServerConfig().getTimeout().intValue())).setRetryAttempts(this.redissonProperties.getSingleServerConfig().getRetryAttempts().intValue())).setRetryInterval(this.redissonProperties.getSingleServerConfig().getRetryInterval().intValue())).setRetryInterval(this.redissonProperties.getSingleServerConfig().getReconnectionTimeout().intValue())).setRetryAttempts(this.redissonProperties.getSingleServerConfig().getFailedAttempts().intValue())).setPassword(this.redisProperties.getPassword())).setSubscriptionsPerConnection(this.redissonProperties.getSingleServerConfig().getSubscriptionsPerConnection().intValue())).setClientName(this.redissonProperties.getSingleServerConfig().getClientName())).setAddress(StringUtils.isNotBlank((CharSequence)this.redissonProperties.getSingleServerConfig().getAddress()) ? "redis://" + this.redissonProperties.getSingleServerConfig().getAddress() : "redis://" + (String)this.redisProperties.getNodes().get(0)).setSubscriptionConnectionMinimumIdleSize(this.redissonProperties.getSingleServerConfig().getSubscriptionConnectionMinimumIdleSize().intValue()).setSubscriptionConnectionPoolSize(this.redissonProperties.getSingleServerConfig().getSubscriptionConnectionPoolSize().intValue()).setConnectionMinimumIdleSize(this.redissonProperties.getSingleServerConfig().getConnectionMinimumIdleSize().intValue()).setDatabase(this.redissonProperties.getSingleServerConfig().getDatabase().intValue()).setDnsMonitoringInterval(Boolean.TRUE.equals(this.redissonProperties.getSingleServerConfig().getDnsMonitoring()) ? this.redissonProperties.getSingleServerConfig().getDnsMonitoringInterval() : -1L);
            }
        }
        catch (Exception e) {
            this.logger.warn("Configuration of Redisson is not correctly: {}", (Object)config.toJSON());
        }
        return config;
    }

    private Config configYaml() throws IOException {
        File file = ResourceUtils.getFile((String)this.redissonProperties.getConfigFile().getYaml());
        return Config.fromYAML((File)file);
    }

    @Bean
    @ConditionalOnMissingBean
    public Config config() throws IOException {
        Config config = !StringUtils.isEmpty((CharSequence)this.redissonProperties.getConfigFile().getJson()) ? this.configJson() : (!StringUtils.isEmpty((CharSequence)this.redissonProperties.getConfigFile().getYaml()) ? this.configYaml() : this.config(this.redisProperties.getCluster(), this.redisProperties.getSentinel()));
        return config;
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean
    public RedissonClient redissonClient(Config config) throws IOException {
        this.logger.debug("create RedissonClient, config is : {}", (Object)config.toJSON());
        return Redisson.create((Config)config);
    }

    @Bean
    public RedissonFactory lockFactory(RedissonClient redissonClient) {
        return new RedissonFactory(redissonClient);
    }
}

